/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reactive;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import reactor.core.publisher.Flux;

public class FluxToMessageChannelResultAdapter
implements StreamListenerResultAdapter<Flux<?>, MessageChannel> {
    private Log log = LogFactory.getLog(FluxToMessageChannelResultAdapter.class);

    public boolean supports(Class<?> resultType, Class<?> bindingTarget) {
        return Flux.class.isAssignableFrom(resultType) && MessageChannel.class.isAssignableFrom(bindingTarget);
    }

    public void adapt(Flux<?> streamListenerResult, MessageChannel bindingTarget) {
        streamListenerResult.doOnError(e -> this.log.error((Object)"Error while processing result", e)).retry().subscribe(result -> bindingTarget.send(result instanceof Message ? (Message)result : MessageBuilder.withPayload((Object)result).build()));
    }
}

