/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reactive;

import org.reactivestreams.Publisher;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.cloud.stream.reactive.FluxToMessageChannelResultAdapter;
import org.springframework.cloud.stream.reactive.shaded.rx.RxReactiveStreams;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import rx.Observable;

public class ObservableToMessageChannelResultAdapter
implements StreamListenerResultAdapter<Observable<?>, MessageChannel> {
    private FluxToMessageChannelResultAdapter fluxToMessageChannelResultAdapter;

    public ObservableToMessageChannelResultAdapter(FluxToMessageChannelResultAdapter fluxToMessageChannelResultAdapter) {
        Assert.notNull((Object)fluxToMessageChannelResultAdapter, (String)"cannot be null");
        this.fluxToMessageChannelResultAdapter = fluxToMessageChannelResultAdapter;
    }

    public boolean supports(Class<?> resultType, Class<?> bindingTarget) {
        return Observable.class.isAssignableFrom(resultType) && MessageChannel.class.isAssignableFrom(bindingTarget);
    }

    public void adapt(Observable<?> streamListenerResult, MessageChannel bindingTarget) {
        Publisher<?> adaptedPublisher = RxReactiveStreams.toPublisher(streamListenerResult);
        this.fluxToMessageChannelResultAdapter.adapt(Flux.from(adaptedPublisher), bindingTarget);
    }
}

