/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.EmbeddedHeadersMessageConverter;
import org.springframework.cloud.stream.binder.MessageValues;
import org.springframework.cloud.stream.binder.PartitionSelectorStrategy;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.StringConvertingContentTypeResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.serializer.support.SerializationFailedException;
import org.springframework.expression.EvaluationContext;
import org.springframework.integration.codec.Codec;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractBinder<T, C extends ConsumerProperties, P extends ProducerProperties>
implements ApplicationContextAware,
InitializingBean,
Binder<T, C, P> {
    protected static final String PARTITION_HEADER = "partition";
    private static final String GROUP_INDEX_DELIMITER = ".";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile AbstractApplicationContext applicationContext;
    private volatile Codec codec;
    private final StringConvertingContentTypeResolver contentTypeResolver = new StringConvertingContentTypeResolver();
    protected final EmbeddedHeadersMessageConverter embeddedHeadersMessageConverter = new EmbeddedHeadersMessageConverter();
    protected volatile EvaluationContext evaluationContext;
    protected volatile PartitionSelectorStrategy partitionSelector;
    private volatile Map<String, Class<?>> payloadTypeCache = new ConcurrentHashMap();

    public static String applyPrefix(String prefix, String name) {
        return prefix + name;
    }

    public static String constructDLQName(String name) {
        return name + ".dlq";
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isInstanceOf(AbstractApplicationContext.class, (Object)applicationContext);
        this.applicationContext = (AbstractApplicationContext)applicationContext;
    }

    protected AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.applicationContext.getBeanFactory();
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    public void setPartitionSelector(PartitionSelectorStrategy partitionSelector) {
        this.partitionSelector = partitionSelector;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public final void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.applicationContext, (String)"The 'applicationContext' property must not be null");
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        }
        this.onInit();
    }

    public MessageValues extractMessageValues(Message<?> receivedMessage) {
        MessageValues messageValues;
        try {
            messageValues = this.embeddedHeadersMessageConverter.extractHeaders(receivedMessage, true);
        }
        catch (Exception e) {
            this.logger.error(EmbeddedHeadersMessageConverter.decodeExceptionMessage(receivedMessage), (Throwable)e);
            messageValues = new MessageValues(receivedMessage);
        }
        return this.deserializePayloadIfNecessary(messageValues);
    }

    protected void onInit() throws Exception {
    }

    @Override
    public final Binding<T> bindConsumer(String name, String group, T target, C properties) {
        if (StringUtils.isEmpty((Object)group)) {
            Assert.isTrue((!((ConsumerProperties)properties).isPartitioned() ? 1 : 0) != 0, (String)"A consumer group is required for a partitioned subscription");
        }
        return this.doBindConsumer(name, group, target, properties);
    }

    protected abstract Binding<T> doBindConsumer(String var1, String var2, T var3, C var4);

    @Override
    public final Binding<T> bindProducer(String name, T outboundBindTarget, P properties) {
        return this.doBindProducer(name, outboundBindTarget, properties);
    }

    protected abstract Binding<T> doBindProducer(String var1, T var2, P var3);

    protected final String groupedName(String name, String group) {
        if (!StringUtils.hasText((String)group)) {
            group = "default";
        }
        return name + GROUP_INDEX_DELIMITER + group;
    }

    protected final MessageValues serializePayloadIfNecessary(Message<?> message) {
        Object originalPayload = message.getPayload();
        Object originalContentType = message.getHeaders().get((Object)"contentType");
        String contentType = JavaClassMimeTypeConversion.mimeTypeFromObject(originalPayload).toString();
        byte[] payload = this.serializePayloadIfNecessary(originalPayload);
        MessageValues messageValues = new MessageValues(message);
        messageValues.setPayload(payload);
        messageValues.put("contentType", (Object)contentType);
        if (originalContentType != null) {
            messageValues.put("originalContentType", (Object)originalContentType.toString());
        }
        return messageValues;
    }

    private byte[] serializePayloadIfNecessary(Object originalPayload) {
        if (originalPayload instanceof byte[]) {
            return (byte[])originalPayload;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (originalPayload instanceof String) {
                return ((String)originalPayload).getBytes("UTF-8");
            }
            this.codec.encode(originalPayload, (OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationFailedException("unable to serialize payload [" + originalPayload.getClass().getName() + "]", (Throwable)e);
        }
    }

    protected final MessageValues deserializePayloadIfNecessary(Message<?> message) {
        return this.deserializePayloadIfNecessary(new MessageValues(message));
    }

    protected final MessageValues deserializePayloadIfNecessary(MessageValues messageValues) {
        MimeType contentType;
        Object originalPayload = messageValues.getPayload();
        Object payload = this.deserializePayload(originalPayload, contentType = this.contentTypeResolver.resolve(messageValues));
        if (payload != null) {
            messageValues.setPayload(payload);
            Object originalContentType = messageValues.get("originalContentType");
            if (originalContentType != null) {
                messageValues.put("contentType", originalContentType);
                messageValues.remove("originalContentType");
            }
        }
        return messageValues;
    }

    private Object deserializePayload(Object payload, MimeType contentType) {
        if (payload instanceof byte[]) {
            if (contentType == null || MimeTypeUtils.APPLICATION_OCTET_STREAM.equals((Object)contentType)) {
                return payload;
            }
            return this.deserializePayload((byte[])payload, contentType);
        }
        return payload;
    }

    private Object deserializePayload(byte[] bytes, MimeType contentType) {
        if ("text".equalsIgnoreCase(contentType.getType()) || MimeTypeUtils.APPLICATION_JSON.equals((Object)contentType)) {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SerializationFailedException("unable to deserialize [java.lang.String]. Encoding not supported.", (Throwable)e);
            }
        }
        String className = JavaClassMimeTypeConversion.classNameFromMimeType(contentType);
        try {
            Class targetType = this.payloadTypeCache.get(className);
            if (targetType == null) {
                targetType = ClassUtils.forName((String)className, null);
                this.payloadTypeCache.put(className, targetType);
            }
            return this.codec.decode(bytes, targetType);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationFailedException("unable to deserialize [" + className + "]. Class not found.", (Throwable)e);
        }
        catch (IOException e) {
            throw new SerializationFailedException("unable to deserialize [" + className + "]", (Throwable)e);
        }
    }

    protected String buildPartitionRoutingExpression(String expressionRoot) {
        return "'" + expressionRoot + "-' + headers['" + PARTITION_HEADER + "']";
    }

    protected RetryTemplate buildRetryTemplateIfRetryEnabled(ConsumerProperties properties) {
        int maxAttempts = properties.getMaxAttempts();
        if (maxAttempts > 1) {
            RetryTemplate template = new RetryTemplate();
            SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy();
            retryPolicy.setMaxAttempts(maxAttempts);
            ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
            backOffPolicy.setInitialInterval((long)properties.getBackOffInitialInterval());
            backOffPolicy.setMultiplier(properties.getBackOffMultiplier());
            backOffPolicy.setMaxInterval((long)properties.getBackOffMaxInterval());
            template.setRetryPolicy((RetryPolicy)retryPolicy);
            template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
            return template;
        }
        return null;
    }

    public void doManualAck(LinkedList<MessageHeaders> messageHeaders) {
    }

    public static abstract class JavaClassMimeTypeConversion {
        private static ConcurrentMap<String, MimeType> mimeTypesCache = new ConcurrentHashMap<String, MimeType>();

        static MimeType mimeTypeFromObject(Object payload) {
            Assert.notNull((Object)payload, (String)"payload object cannot be null.");
            if (payload instanceof byte[]) {
                return MimeTypeUtils.APPLICATION_OCTET_STREAM;
            }
            if (payload instanceof String) {
                return MimeTypeUtils.TEXT_PLAIN;
            }
            String className = payload.getClass().getName();
            MimeType mimeType = (MimeType)mimeTypesCache.get(className);
            if (mimeType == null) {
                String modifiedClassName = className;
                if (payload.getClass().isArray()) {
                    if (modifiedClassName.endsWith(";")) {
                        modifiedClassName = modifiedClassName.substring(0, modifiedClassName.length() - 1);
                    }
                    modifiedClassName = "\"" + modifiedClassName + "\"";
                }
                mimeType = MimeType.valueOf((String)("application/x-java-object;type=" + modifiedClassName));
                mimeTypesCache.put(className, mimeType);
            }
            return mimeType;
        }

        static String classNameFromMimeType(MimeType mimeType) {
            Assert.notNull((Object)mimeType, (String)"mimeType cannot be null.");
            String className = mimeType.getParameter("type");
            if (className == null) {
                return null;
            }
            if ((className = className.replace("\"", "")).contains("[L")) {
                className = className + ";";
            }
            return className;
        }
    }
}

