/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.CustomValidatorBean;

public class ChannelBindingService {
    private final Log log = LogFactory.getLog(ChannelBindingService.class);
    private BinderFactory<MessageChannel> binderFactory;
    private final ChannelBindingServiceProperties channelBindingServiceProperties;
    private final Map<String, Binding<MessageChannel>> producerBindings = new HashMap<String, Binding<MessageChannel>>();
    private final Map<String, List<Binding<MessageChannel>>> consumerBindings = new HashMap<String, List<Binding<MessageChannel>>>();

    public ChannelBindingService(ChannelBindingServiceProperties channelBindingServiceProperties, BinderFactory<MessageChannel> binderFactory) {
        this.channelBindingServiceProperties = channelBindingServiceProperties;
        this.binderFactory = binderFactory;
    }

    public Collection<Binding<MessageChannel>> bindConsumer(MessageChannel inputChannel, String inputChannelName) {
        String channelBindingTarget = this.channelBindingServiceProperties.getBindingDestination(inputChannelName);
        String[] channelBindingTargets = StringUtils.commaDelimitedListToStringArray((String)channelBindingTarget);
        ArrayList<Binding<MessageChannel>> bindings = new ArrayList<Binding<MessageChannel>>();
        Binder<MessageChannel, ?, ?> binder = this.getBinderForChannel(inputChannelName);
        ExtendedConsumerProperties consumerProperties = this.channelBindingServiceProperties.getConsumerProperties(inputChannelName);
        if (binder instanceof ExtendedPropertiesBinder) {
            ExtendedPropertiesBinder extendedPropertiesBinder = (ExtendedPropertiesBinder)binder;
            Object extension = extendedPropertiesBinder.getExtendedConsumerProperties(inputChannelName);
            ExtendedConsumerProperties extendedConsumerProperties = new ExtendedConsumerProperties(extension);
            BeanUtils.copyProperties((Object)consumerProperties, extendedConsumerProperties);
            consumerProperties = extendedConsumerProperties;
        }
        ProducerConsumerPropertiesValidator.validate(consumerProperties);
        for (String target : channelBindingTargets) {
            Binding<MessageChannel> binding = binder.bindConsumer(target, this.channelBindingServiceProperties.getGroup(inputChannelName), inputChannel, consumerProperties);
            bindings.add(binding);
        }
        this.consumerBindings.put(inputChannelName, bindings);
        return bindings;
    }

    public Binding<MessageChannel> bindProducer(MessageChannel outputChannel, String outputChannelName) {
        String channelBindingTarget = this.channelBindingServiceProperties.getBindingDestination(outputChannelName);
        Binder<MessageChannel, ?, ?> binder = this.getBinderForChannel(outputChannelName);
        ExtendedProducerProperties producerProperties = this.channelBindingServiceProperties.getProducerProperties(outputChannelName);
        if (binder instanceof ExtendedPropertiesBinder) {
            ExtendedPropertiesBinder extendedPropertiesBinder = (ExtendedPropertiesBinder)binder;
            Object extension = extendedPropertiesBinder.getExtendedProducerProperties(outputChannelName);
            ExtendedProducerProperties extendedProducerProperties = new ExtendedProducerProperties(extension);
            BeanUtils.copyProperties((Object)producerProperties, extendedProducerProperties);
            producerProperties = extendedProducerProperties;
        }
        ProducerConsumerPropertiesValidator.validate(producerProperties);
        Binding<MessageChannel> binding = binder.bindProducer(channelBindingTarget, outputChannel, producerProperties);
        this.producerBindings.put(outputChannelName, binding);
        return binding;
    }

    public void unbindConsumers(String inputChannelName) {
        List<Binding<MessageChannel>> bindings = this.consumerBindings.remove(inputChannelName);
        if (bindings != null && !CollectionUtils.isEmpty(bindings)) {
            for (Binding<MessageChannel> binding : bindings) {
                binding.unbind();
            }
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Trying to unbind channel '" + inputChannelName + "', but no binding found."));
        }
    }

    public void unbindProducers(String outputChannelName) {
        Binding<MessageChannel> binding = this.producerBindings.remove(outputChannelName);
        if (binding != null) {
            binding.unbind();
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Trying to unbind channel '" + outputChannelName + "', but no binding found."));
        }
    }

    private Binder<MessageChannel, ?, ?> getBinderForChannel(String channelName) {
        String transport = this.channelBindingServiceProperties.getBinder(channelName);
        return this.binderFactory.getBinder(transport);
    }

    private static class ProducerConsumerPropertiesValidator {
        private static CustomValidatorBean validator = new CustomValidatorBean();

        private ProducerConsumerPropertiesValidator() {
        }

        static void validate(Object properties) {
            RelaxedDataBinder dataBinder = new RelaxedDataBinder(properties);
            dataBinder.setValidator((Validator)validator);
            dataBinder.validate();
            if (dataBinder.getBindingResult().hasErrors()) {
                throw new IllegalStateException(dataBinder.getBindingResult().toString());
            }
        }

        static {
            validator.afterPropertiesSet();
        }
    }
}

