/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class MessageConverterConfigurer
implements MessageChannelConfigurer,
BeanFactoryAware,
InitializingBean {
    private final MessageBuilderFactory messageBuilderFactory;
    private ConfigurableListableBeanFactory beanFactory;
    private final CompositeMessageConverterFactory compositeMessageConverterFactory;
    private final ChannelBindingServiceProperties channelBindingServiceProperties;

    public MessageConverterConfigurer(ChannelBindingServiceProperties channelBindingServiceProperties, MessageBuilderFactory messageBuilderFactory, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        Assert.notNull((Object)compositeMessageConverterFactory, (String)"The message converter factory cannot be null");
        this.messageBuilderFactory = messageBuilderFactory;
        this.channelBindingServiceProperties = channelBindingServiceProperties;
        this.compositeMessageConverterFactory = compositeMessageConverterFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanFactory, (String)"Bean factory cannot be empty");
    }

    @Override
    public void configureMessageChannel(MessageChannel channel, String channelName) {
        Assert.isAssignable(AbstractMessageChannel.class, channel.getClass());
        AbstractMessageChannel messageChannel = (AbstractMessageChannel)channel;
        BindingProperties bindingProperties = this.channelBindingServiceProperties.getBindingProperties(channelName);
        final String contentType = bindingProperties.getContentType();
        if (StringUtils.hasText((String)contentType)) {
            MimeType mimeType = MessageConverterUtils.getMimeType(contentType);
            CompositeMessageConverter messageConverter = this.compositeMessageConverterFactory.getMessageConverterForType(mimeType);
            Class[] supportedDataTypes = this.compositeMessageConverterFactory.supportedDataTypes(mimeType);
            messageChannel.setDatatypes(supportedDataTypes);
            messageChannel.setMessageConverter((MessageConverter)new MessageWrappingMessageConverter((SmartMessageConverter)messageConverter, mimeType));
            messageChannel.addInterceptor((ChannelInterceptor)new ChannelInterceptorAdapter(){

                public Message<?> preSend(Message<?> message, MessageChannel messageChannel) {
                    Object contentTypeFromMessage = message.getHeaders().get((Object)"contentType");
                    if (contentTypeFromMessage == null) {
                        return MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("contentType", (Object)contentType).build();
                    }
                    return message;
                }
            });
        }
    }

    class MessageWrappingMessageConverter
    implements SmartMessageConverter {
        private final MimeType contentType;
        private final SmartMessageConverter delegate;

        public MessageWrappingMessageConverter(SmartMessageConverter delegate, MimeType contentType) {
            Assert.notNull((Object)delegate, (String)"Delegate converter cannot be null");
            Assert.notNull((Object)contentType, (String)"Content type cannot be null");
            this.delegate = delegate;
            this.contentType = contentType;
        }

        public Object fromMessage(Message<?> message, Class<?> targetClass) {
            Object converted = this.delegate.fromMessage(message, targetClass);
            if (converted instanceof Message) {
                return converted;
            }
            return this.build(converted, message.getHeaders());
        }

        public Object fromMessage(Message<?> message, Class<?> targetClass, Object conversionHint) {
            Object converted = this.delegate.fromMessage(message, targetClass, conversionHint);
            if (converted == null || converted instanceof Message) {
                return converted;
            }
            return this.build(converted, message.getHeaders());
        }

        public Message<?> toMessage(Object payload, MessageHeaders headers) {
            return this.delegate.toMessage(payload, headers);
        }

        public Message<?> toMessage(Object payload, MessageHeaders headers, Object conversionHint) {
            return this.delegate.toMessage(payload, headers, conversionHint);
        }

        protected final Object build(Object payload, MessageHeaders headers) {
            MimeType messageContentType = MessageConverterUtils.X_JAVA_OBJECT.equals((Object)this.contentType) ? MessageConverterUtils.javaObjectMimeType(payload.getClass()) : this.contentType;
            return MessageConverterConfigurer.this.messageBuilderFactory.withPayload(payload).copyHeaders((Map)headers).copyHeaders(Collections.singletonMap("contentType", messageContentType.toString())).build();
        }
    }
}

