/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binding.BindableChannelFactory;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.cloud.stream.binding.BinderAwareRouterBeanPostProcessor;
import org.springframework.cloud.stream.binding.ChannelBindingService;
import org.springframework.cloud.stream.binding.CompositeMessageChannelConfigurer;
import org.springframework.cloud.stream.binding.ContextStartAfterRefreshListener;
import org.springframework.cloud.stream.binding.DefaultBindableChannelFactory;
import org.springframework.cloud.stream.binding.DynamicDestinationsBindable;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.binding.MessageConverterConfigurer;
import org.springframework.cloud.stream.binding.OutputBindingLifecycle;
import org.springframework.cloud.stream.binding.SingleChannelBindable;
import org.springframework.cloud.stream.binding.StreamListenerAnnotationBeanPostProcessor;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.config.IntegrationEvaluationContextFactoryBean;
import org.springframework.integration.json.JsonPropertyAccessor;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.tuple.spel.TuplePropertyAccessor;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableConfigurationProperties(value={ChannelBindingServiceProperties.class})
public class ChannelBindingServiceConfiguration {
    private static final String ERROR_CHANNEL_NAME = "error";
    @Autowired
    private MessageBuilderFactory messageBuilderFactory;
    @Autowired(required=false)
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    private List<AbstractFromMessageConverter> customMessageConverters;

    @Bean
    @ConditionalOnMissingBean(value={ChannelBindingService.class})
    public ChannelBindingService bindingService(ChannelBindingServiceProperties channelBindingServiceProperties, BinderFactory<MessageChannel> binderFactory) {
        return new ChannelBindingService(channelBindingServiceProperties, binderFactory);
    }

    @Bean
    public MessageConverterConfigurer messageConverterConfigurer(ChannelBindingServiceProperties channelBindingServiceProperties, MessageBuilderFactory messageBuilderFactory, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        return new MessageConverterConfigurer(channelBindingServiceProperties, messageBuilderFactory, compositeMessageConverterFactory);
    }

    @Bean
    public BindableChannelFactory channelFactory(CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        return new DefaultBindableChannelFactory(compositeMessageChannelConfigurer);
    }

    @Bean
    public CompositeMessageChannelConfigurer compositeMessageChannelConfigurer(MessageConverterConfigurer messageConverterConfigurer) {
        ArrayList<MessageChannelConfigurer> configurerList = new ArrayList<MessageChannelConfigurer>();
        configurerList.add(messageConverterConfigurer);
        return new CompositeMessageChannelConfigurer(configurerList);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public OutputBindingLifecycle outputBindingLifecycle() {
        return new OutputBindingLifecycle();
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public InputBindingLifecycle inputBindingLifecycle() {
        return new InputBindingLifecycle();
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public ContextStartAfterRefreshListener contextStartAfterRefreshListener() {
        return new ContextStartAfterRefreshListener();
    }

    @Bean
    public BinderAwareChannelResolver binderAwareChannelResolver(BinderFactory<MessageChannel> binderFactory, ChannelBindingServiceProperties channelBindingServiceProperties, BindableChannelFactory bindableChannelFactory) {
        return new BinderAwareChannelResolver(binderFactory, channelBindingServiceProperties, this.dynamicBindable(), bindableChannelFactory);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.stream.bindings.error.destination"})
    public SingleChannelBindable errorChannelBindable(@Qualifier(value="errorChannel") PublishSubscribeChannel errorChannel) {
        return new SingleChannelBindable(ERROR_CHANNEL_NAME, (MessageChannel)errorChannel);
    }

    @Bean
    public DynamicDestinationsBindable dynamicBindable() {
        return new DynamicDestinationsBindable();
    }

    @Bean
    public CompositeMessageConverterFactory compositeMessageConverterFactory() {
        ArrayList<AbstractFromMessageConverter> messageConverters = new ArrayList<AbstractFromMessageConverter>();
        if (!CollectionUtils.isEmpty(this.customMessageConverters)) {
            messageConverters.addAll(Collections.unmodifiableCollection(this.customMessageConverters));
        }
        return new CompositeMessageConverterFactory(messageConverters, this.objectMapper);
    }

    @Bean
    public static StreamListenerAnnotationBeanPostProcessor bindToAnnotationBeanPostProcessor(@Lazy BinderAwareChannelResolver binderAwareChannelResolver, @Lazy CompositeMessageConverterFactory compositeMessageConverterFactory) {
        DefaultMessageHandlerMethodFactory messageHandlerMethodFactory = new DefaultMessageHandlerMethodFactory();
        messageHandlerMethodFactory.setMessageConverter((MessageConverter)compositeMessageConverterFactory.getMessageConverterForAllRegistered());
        messageHandlerMethodFactory.afterPropertiesSet();
        return new StreamListenerAnnotationBeanPostProcessor((DestinationResolver<MessageChannel>)binderAwareChannelResolver, (MessageHandlerMethodFactory)messageHandlerMethodFactory);
    }

    @Configuration
    protected static class PostProcessorConfiguration {
        private BinderAwareChannelResolver binderAwareChannelResolver;

        protected PostProcessorConfiguration() {
        }

        @Bean
        public BinderAwareRouterBeanPostProcessor binderAwareRouterBeanPostProcessor(final ConfigurableListableBeanFactory beanFactory) {
            return new BinderAwareRouterBeanPostProcessor(new DestinationResolver<MessageChannel>(){

                public MessageChannel resolveDestination(String name) throws DestinationResolutionException {
                    if (PostProcessorConfiguration.this.binderAwareChannelResolver == null) {
                        PostProcessorConfiguration.this.binderAwareChannelResolver = (BinderAwareChannelResolver)((Object)BeanFactoryUtils.beanOfType((ListableBeanFactory)beanFactory, BinderAwareChannelResolver.class));
                    }
                    return PostProcessorConfiguration.this.binderAwareChannelResolver.resolveDestination(name);
                }
            });
        }

        @Bean
        public static BeanPostProcessor propertyAccessorBeanPostProcessor() {
            final HashMap<String, Object> accessors = new HashMap<String, Object>();
            accessors.put("tuplePropertyAccessor", new TuplePropertyAccessor());
            accessors.put("jsonPropertyAccessor", new JsonPropertyAccessor());
            return new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    if ("integrationEvaluationContext".equals(beanName)) {
                        IntegrationEvaluationContextFactoryBean factoryBean = (IntegrationEvaluationContextFactoryBean)bean;
                        Map factoryBeanAccessors = factoryBean.getPropertyAccessors();
                        for (Map.Entry entry : accessors.entrySet()) {
                            if (factoryBeanAccessors.containsKey(entry.getKey())) continue;
                            factoryBeanAccessors.put(entry.getKey(), entry.getValue());
                        }
                        factoryBean.setPropertyAccessors(factoryBeanAccessors);
                    }
                    return bean;
                }

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }
            };
        }
    }
}

