/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.util.MimeTypeUtils;

public class PojoToJsonMessageConverter
extends AbstractFromMessageConverter {
    private final ObjectMapper objectMapper;
    @Value(value="${typeconversion.json.prettyPrint:false}")
    private volatile boolean prettyPrint;

    public PojoToJsonMessageConverter(ObjectMapper objectMapper) {
        super(MimeTypeUtils.APPLICATION_JSON);
        this.objectMapper = objectMapper != null ? objectMapper : new ObjectMapper();
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{String.class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return null;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        String result;
        try {
            result = this.prettyPrint ? this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(message.getPayload()) : this.objectMapper.writeValueAsString(message.getPayload());
        }
        catch (JsonProcessingException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return result;
    }
}

