/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import org.springframework.cloud.stream.binder.Binding;
import org.springframework.context.Lifecycle;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DefaultBinding<T>
implements Binding<T> {
    protected final String name;
    protected final String group;
    protected final T target;
    protected final Lifecycle endpoint;

    public DefaultBinding(String name, String group, T target, Lifecycle endpoint) {
        Assert.notNull(target, (String)"target must not be null");
        Assert.notNull((Object)endpoint, (String)"endpoint must not be null");
        this.name = name;
        this.group = group;
        this.target = target;
        this.endpoint = endpoint;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public final void unbind() {
        if (this.endpoint != null) {
            this.endpoint.stop();
        }
        this.afterUnbind();
    }

    protected void afterUnbind() {
    }

    public String toString() {
        return " Binding [name=" + this.name + ", target=" + this.target + ", endpoint=" + (this.endpoint instanceof NamedComponent ? ((NamedComponent)this.endpoint).getComponentName() : ObjectUtils.nullSafeToString((Object)this.endpoint)) + "]";
    }
}

