/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.tuple.Tuple;
import org.springframework.tuple.TupleBuilder;

public class TupleJsonMessageConverter
extends AbstractMessageConverter {
    @Value(value="${typeconversion.json.prettyPrint:false}")
    private volatile boolean prettyPrint;
    private final ObjectMapper objectMapper;

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TupleJsonMessageConverter(ObjectMapper objectMapper) {
        super(MessageConverterUtils.X_SPRING_TUPLE);
        this.objectMapper = objectMapper != null ? objectMapper : new ObjectMapper();
    }

    protected boolean supports(Class<?> clazz) {
        return Tuple.class.isAssignableFrom(clazz);
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        String json;
        Tuple t = (Tuple)payload;
        if (this.prettyPrint) {
            try {
                Object tmp = this.objectMapper.readValue(t.toString(), Object.class);
                json = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(tmp);
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        } else {
            json = t.toString();
        }
        return json;
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        String source = message.getPayload() instanceof byte[] ? new String((byte[])message.getPayload(), Charset.forName("UTF-8")) : message.getPayload().toString();
        return TupleBuilder.fromString((String)source);
    }
}

