/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.config.DefaultPollerProperties;
import org.springframework.cloud.stream.endpoint.ChannelsEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.scheduling.PollerMetadata;

@Configuration
@ConditionalOnBean(value={BindingService.class})
@EnableConfigurationProperties(value={DefaultPollerProperties.class})
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
public class ChannelBindingAutoConfiguration {
    @Autowired
    private DefaultPollerProperties poller;
    @Autowired(required=false)
    private List<Bindable> adapters;

    @Bean(name={"org.springframework.integration.context.defaultPollerMetadata"})
    @ConditionalOnMissingBean(value={PollerMetadata.class})
    public PollerMetadata defaultPoller() {
        return this.poller.getPollerMetadata();
    }

    @Bean
    public ChannelsEndpoint channelsEndpoint(BindingServiceProperties properties) {
        return new ChannelsEndpoint(this.adapters, properties);
    }

    @Bean
    @ConditionalOnEnabledHealthIndicator(value="binders")
    @ConditionalOnMissingBean(name={"bindersHealthIndicator"})
    public CompositeHealthIndicator bindersHealthIndicator() {
        return new CompositeHealthIndicator((HealthAggregator)new OrderedHealthAggregator());
    }
}

