/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.CustomValidatorBean;

public class BindingService {
    private final CustomValidatorBean validator;
    private final Log log = LogFactory.getLog(BindingService.class);
    private BinderFactory binderFactory;
    private final BindingServiceProperties bindingServiceProperties;
    private final Map<String, Binding<?>> producerBindings = new HashMap();
    private final Map<String, List<Binding<?>>> consumerBindings = new HashMap();

    public BindingService(BindingServiceProperties bindingServiceProperties, BinderFactory binderFactory) {
        this.bindingServiceProperties = bindingServiceProperties;
        this.binderFactory = binderFactory;
        this.validator = new CustomValidatorBean();
        this.validator.afterPropertiesSet();
    }

    public <T> Collection<Binding<T>> bindConsumer(T input, String inputName) {
        String bindingTarget = this.bindingServiceProperties.getBindingDestination(inputName);
        String[] bindingTargets = StringUtils.commaDelimitedListToStringArray((String)bindingTarget);
        ArrayList<Binding<T>> bindings = new ArrayList();
        Binder<?, ?, ?> binder = this.getBinder(inputName, input.getClass());
        ExtendedConsumerProperties consumerProperties = this.bindingServiceProperties.getConsumerProperties(inputName);
        if (binder instanceof ExtendedPropertiesBinder) {
            Object extension = ((ExtendedPropertiesBinder)binder).getExtendedConsumerProperties(inputName);
            ExtendedConsumerProperties extendedConsumerProperties = new ExtendedConsumerProperties(extension);
            BeanUtils.copyProperties((Object)consumerProperties, extendedConsumerProperties);
            consumerProperties = extendedConsumerProperties;
        }
        this.validate(consumerProperties);
        for (String target : bindingTargets) {
            Binding<?> binding = binder.bindConsumer(target, this.bindingServiceProperties.getGroup(inputName), input, consumerProperties);
            bindings.add(binding);
        }
        bindings = Collections.unmodifiableCollection(bindings);
        this.consumerBindings.put(inputName, new ArrayList(bindings));
        return bindings;
    }

    public <T> Binding<T> bindProducer(T output, String outputName) {
        String bindingTarget = this.bindingServiceProperties.getBindingDestination(outputName);
        Binder<?, ?, ?> binder = this.getBinder(outputName, output.getClass());
        ExtendedProducerProperties producerProperties = this.bindingServiceProperties.getProducerProperties(outputName);
        if (binder instanceof ExtendedPropertiesBinder) {
            Object extension = ((ExtendedPropertiesBinder)binder).getExtendedProducerProperties(outputName);
            ExtendedProducerProperties extendedProducerProperties = new ExtendedProducerProperties(extension);
            BeanUtils.copyProperties((Object)producerProperties, extendedProducerProperties);
            producerProperties = extendedProducerProperties;
        }
        this.validate(producerProperties);
        Binding<?> binding = binder.bindProducer(bindingTarget, output, producerProperties);
        this.producerBindings.put(outputName, binding);
        return binding;
    }

    public void unbindConsumers(String inputName) {
        List<Binding<?>> bindings = this.consumerBindings.remove(inputName);
        if (bindings != null && !CollectionUtils.isEmpty(bindings)) {
            for (Binding<?> binding : bindings) {
                binding.unbind();
            }
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Trying to unbind '" + inputName + "', but no binding found."));
        }
    }

    public void unbindProducers(String outputName) {
        Binding<?> binding = this.producerBindings.remove(outputName);
        if (binding != null) {
            binding.unbind();
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Trying to unbind '" + outputName + "', but no binding found."));
        }
    }

    private <T> Binder<T, ?, ?> getBinder(String channelName, Class<T> bindableType) {
        String binderConfigurationName = this.bindingServiceProperties.getBinder(channelName);
        return this.binderFactory.getBinder(binderConfigurationName, bindableType);
    }

    @Deprecated
    public BindingServiceProperties getChannelBindingServiceProperties() {
        return this.bindingServiceProperties;
    }

    public BindingServiceProperties getBindingServiceProperties() {
        return this.bindingServiceProperties;
    }

    private void validate(Object properties) {
        RelaxedDataBinder dataBinder = new RelaxedDataBinder(properties);
        dataBinder.setValidator((Validator)this.validator);
        dataBinder.validate();
        if (dataBinder.getBindingResult().hasErrors()) {
            throw new IllegalStateException(dataBinder.getBindingResult().toString());
        }
    }
}

