/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.stream.aggregate.AggregateApplication;
import org.springframework.cloud.stream.aggregate.AggregateApplicationUtils;
import org.springframework.cloud.stream.aggregate.SharedBindingTargetRegistry;
import org.springframework.cloud.stream.aggregate.SharedChannelRegistry;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.binding.BindableProxyFactory;
import org.springframework.cloud.stream.config.ChannelBindingAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@EnableBinding
public class AggregateApplicationBuilder
implements AggregateApplication,
ApplicationContextAware,
SmartInitializingSingleton {
    private static final String CHILD_CONTEXT_SUFFIX = ".spring.cloud.stream.context";
    private static final Bindable<Map<String, String>> STRING_STRING_MAP = Bindable.mapOf(String.class, String.class);
    private SourceConfigurer sourceConfigurer;
    private SinkConfigurer sinkConfigurer;
    private List<ProcessorConfigurer> processorConfigurers = new ArrayList<ProcessorConfigurer>();
    private AggregateApplicationBuilder applicationBuilder = this;
    private ConfigurableApplicationContext parentContext;
    private List<Object> parentSources = new ArrayList<Object>();
    private List<String> parentArgs = new ArrayList<String>();
    private boolean headless = true;
    private boolean webEnvironment = true;

    public AggregateApplicationBuilder(String ... args) {
        this(new Object[]{ParentConfiguration.class}, args);
    }

    public AggregateApplicationBuilder(Object source, String ... args) {
        this(new Object[]{source}, args);
    }

    public AggregateApplicationBuilder(Object[] sources, String[] args) {
        this.addParentSources(sources);
        this.parentArgs.addAll(Arrays.asList(args));
    }

    private void addParentSources(Object[] sources) {
        if (!this.parentSources.contains(ParentConfiguration.class)) {
            this.parentSources.add(ParentConfiguration.class);
        }
        this.parentSources.addAll(Arrays.asList(sources));
    }

    public AggregateApplicationBuilder parent(Object source, String ... args) {
        return this.parent(new Object[]{source}, args);
    }

    public AggregateApplicationBuilder parent(Object[] sources, String[] args) {
        this.addParentSources(sources);
        this.parentArgs.addAll(Arrays.asList(args));
        return this;
    }

    public AggregateApplicationBuilder web(boolean webEnvironment) {
        this.webEnvironment = webEnvironment;
        return this;
    }

    public AggregateApplicationBuilder headless(boolean headless) {
        this.headless = headless;
        return this;
    }

    public void afterSingletonsInstantiated() {
        this.run(new String[0]);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = (ConfigurableApplicationContext)applicationContext;
    }

    @Override
    public <T> T getBinding(Class<T> bindableType, String namespace) {
        if (this.parentContext == null) {
            throw new IllegalStateException("The aggregate application has not been started yet");
        }
        try {
            ChildContextHolder contextHolder = (ChildContextHolder)this.parentContext.getBean(namespace + CHILD_CONTEXT_SUFFIX, ChildContextHolder.class);
            return (T)contextHolder.getChildContext().getBean(bindableType);
        }
        catch (BeansException e) {
            throw new IllegalStateException("Binding not found for '" + bindableType.getName() + "' into namespace " + namespace);
        }
    }

    public SourceConfigurer from(Class<?> app) {
        SourceConfigurer sourceConfigurer;
        this.sourceConfigurer = sourceConfigurer = new SourceConfigurer(app);
        return sourceConfigurer;
    }

    public ConfigurableApplicationContext run(String ... parentArgs) {
        this.parentArgs.addAll(Arrays.asList(parentArgs));
        ArrayList<AppConfigurer> apps = new ArrayList<AppConfigurer>();
        if (this.sourceConfigurer != null) {
            apps.add(this.sourceConfigurer);
        }
        if (!this.processorConfigurers.isEmpty()) {
            for (ProcessorConfigurer processorConfigurer : this.processorConfigurers) {
                apps.add(processorConfigurer);
            }
        }
        if (this.sinkConfigurer != null) {
            apps.add(this.sinkConfigurer);
        }
        LinkedHashMap appsToEmbed = new LinkedHashMap();
        LinkedHashMap<AppConfigurer, String> appConfigurers = new LinkedHashMap<AppConfigurer, String>();
        for (int i = 0; i < apps.size(); ++i) {
            AppConfigurer appConfigurer = (AppConfigurer)apps.get(i);
            Class<?> clazz = appConfigurer.getApp();
            if (appConfigurer.namespace == null) {
                appConfigurer.namespace = AggregateApplicationUtils.getDefaultNamespace(appConfigurer.getApp().getName().replaceAll("\\$", "."), i);
            }
            appsToEmbed.put(clazz, appConfigurer.namespace);
            appConfigurers.put(appConfigurer, appConfigurer.namespace);
        }
        if (this.parentContext == null) {
            if (Boolean.TRUE.equals(this.webEnvironment)) {
                this.addParentSources(new Object[]{ServletWebServerFactoryAutoConfiguration.class});
            }
            this.parentContext = AggregateApplicationUtils.createParentContext(this.parentSources.toArray(new Class[0]), this.parentArgs.toArray(new String[0]), this.selfContained(), this.webEnvironment, this.headless);
        } else if (BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.parentContext, SharedBindingTargetRegistry.class).size() == 0) {
            SharedBindingTargetRegistry sharedBindingTargetRegistry = new SharedBindingTargetRegistry();
            this.parentContext.getBeanFactory().registerSingleton("sharedBindingTargetRegistry", (Object)sharedBindingTargetRegistry);
            this.parentContext.getBeanFactory().registerSingleton("sharedChannelRegistry", (Object)new SharedChannelRegistry(sharedBindingTargetRegistry));
        }
        SharedBindingTargetRegistry sharedBindingTargetRegistry = (SharedBindingTargetRegistry)this.parentContext.getBean(SharedBindingTargetRegistry.class);
        AggregateApplicationUtils.prepareSharedBindingTargetRegistry(sharedBindingTargetRegistry, appsToEmbed);
        for (Map.Entry entry : appConfigurers.entrySet()) {
            AppConfigurer appConfigurer = (AppConfigurer)entry.getKey();
            if (entry.getValue() == null) continue;
            String namespace = ((String)entry.getValue()).toLowerCase();
            LinkedHashSet<String> argsToUpdate = new LinkedHashSet<String>();
            LinkedHashSet<String> argKeys = new LinkedHashSet<String>();
            Map<String, String> target = this.bindProperties(namespace, (Environment)this.parentContext.getEnvironment());
            if (!target.isEmpty()) {
                for (Map.Entry<String, String> entry2 : target.entrySet()) {
                    String key = entry2.getKey();
                    argKeys.add(key);
                    argsToUpdate.add("--" + key + "=" + entry2.getValue());
                }
            }
            if (argsToUpdate.isEmpty()) continue;
            appConfigurer.args(argsToUpdate.toArray(new String[0]));
        }
        for (int i = apps.size() - 1; i >= 0; --i) {
            AppConfigurer appConfigurer = (AppConfigurer)apps.get(i);
            appConfigurer.embed();
        }
        if (BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.parentContext, AggregateApplication.class).size() == 0) {
            this.parentContext.getBeanFactory().registerSingleton("aggregateApplicationAccessor", (Object)this);
        }
        return this.parentContext;
    }

    private boolean selfContained() {
        return this.sourceConfigurer != null && this.sinkConfigurer != null;
    }

    private ChildContextBuilder childContext(Class<?> app, ConfigurableApplicationContext parentContext, String namespace) {
        return new ChildContextBuilder(AggregateApplicationUtils.embedApp(parentContext, namespace, app));
    }

    private Map<String, String> bindProperties(String namepace, Environment environment) {
        BindResult bindResult = Binder.get((Environment)environment).bind(namepace, STRING_STRING_MAP);
        HashMap<String, String> target = bindResult.isBound() ? (HashMap<String, String>)bindResult.get() : new HashMap<String, String>();
        return target;
    }

    private final class ChildContextBuilder {
        private SpringApplicationBuilder builder;
        private String configName;
        private String[] args;

        private ChildContextBuilder(SpringApplicationBuilder builder) {
            this.builder = builder;
        }

        public ChildContextBuilder profiles(String ... profiles) {
            if (profiles != null) {
                this.builder.profiles(profiles);
            }
            return this;
        }

        public ChildContextBuilder config(String ... configs) {
            if (configs != null) {
                this.configName = StringUtils.arrayToCommaDelimitedString((Object[])configs);
            }
            return this;
        }

        public ChildContextBuilder args(String ... args) {
            this.args = args;
            return this;
        }

        public ConfigurableApplicationContext run() {
            ArrayList<String> args = new ArrayList<String>();
            if (this.args != null) {
                args.addAll(Arrays.asList(this.args));
            }
            if (this.configName != null) {
                args.add("--spring.config.name=" + this.configName);
            }
            return this.builder.run(args.toArray(new String[0]));
        }
    }

    public abstract class AppConfigurer<T extends AppConfigurer<T>> {
        Class<?> app;
        String[] args;
        String[] names;
        String[] profiles;
        String namespace;

        Class<?> getApp() {
            return this.app;
        }

        public T as(String ... names) {
            this.names = names;
            return this.getConfigurer();
        }

        public T args(String ... args) {
            this.args = args;
            return this.getConfigurer();
        }

        public T profiles(String ... profiles) {
            this.profiles = profiles;
            return this.getConfigurer();
        }

        private T getConfigurer() {
            return (T)this;
        }

        public T namespace(String namespace) {
            this.namespace = namespace;
            return this.getConfigurer();
        }

        public ConfigurableApplicationContext run(String ... args) {
            return AggregateApplicationBuilder.this.applicationBuilder.run(args);
        }

        void embed() {
            ConfigurableApplicationContext childContext = AggregateApplicationBuilder.this.childContext(this.app, AggregateApplicationBuilder.this.parentContext, this.namespace).args(this.args).config(this.names).profiles(this.profiles).run();
            Map bindableProxies = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)childContext.getBeanFactory(), BindableProxyFactory.class);
            for (String bindableProxyName : bindableProxies.keySet()) {
                try {
                    AggregateApplicationBuilder.this.parentContext.getBeanFactory().registerSingleton(this.getNamespace() + AggregateApplicationBuilder.CHILD_CONTEXT_SUFFIX, (Object)new ChildContextHolder(childContext));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error while trying to register the aggregate bound interface '" + bindableProxyName + "' into namespace '" + this.getNamespace() + "'", e);
                }
            }
        }

        public AggregateApplication build() {
            return AggregateApplicationBuilder.this.applicationBuilder;
        }

        public String[] getArgs() {
            return this.args;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    public class ProcessorConfigurer
    extends AppConfigurer<ProcessorConfigurer> {
        public ProcessorConfigurer(Class<?> app) {
            this.app = app;
            AggregateApplicationBuilder.this.processorConfigurers.add(this);
        }

        public SinkConfigurer to(Class<?> sink) {
            return new SinkConfigurer(sink);
        }

        public ProcessorConfigurer via(Class<?> processor) {
            return new ProcessorConfigurer(processor);
        }
    }

    public class SinkConfigurer
    extends AppConfigurer<SinkConfigurer> {
        public SinkConfigurer(Class<?> app) {
            this.app = app;
            AggregateApplicationBuilder.this.sinkConfigurer = this;
        }
    }

    public class SourceConfigurer
    extends AppConfigurer<SourceConfigurer> {
        public SourceConfigurer(Class<?> app) {
            this.app = app;
            AggregateApplicationBuilder.this.sourceConfigurer = this;
        }

        public SinkConfigurer to(Class<?> sink) {
            return new SinkConfigurer(sink);
        }

        public ProcessorConfigurer via(Class<?> processor) {
            return new ProcessorConfigurer(processor);
        }
    }

    @ImportAutoConfiguration(value={ChannelBindingAutoConfiguration.class, EndpointAutoConfiguration.class})
    @EnableBinding
    public static class ParentConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={SharedBindingTargetRegistry.class})
        public SharedBindingTargetRegistry sharedBindingTargetRegistry() {
            return new SharedBindingTargetRegistry();
        }

        @Bean
        @ConditionalOnMissingBean(value={SharedChannelRegistry.class})
        public SharedChannelRegistry sharedChannelRegistry(SharedBindingTargetRegistry sharedBindingTargetRegistry) {
            return new SharedChannelRegistry(sharedBindingTargetRegistry);
        }
    }

    private static class ChildContextHolder {
        private final ConfigurableApplicationContext childContext;

        ChildContextHolder(ConfigurableApplicationContext childContext) {
            Assert.notNull((Object)childContext, (String)"cannot be null");
            this.childContext = childContext;
        }

        public ConfigurableApplicationContext getChildContext() {
            return this.childContext;
        }
    }
}

