/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.Banner;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.reflection.GenericsUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultBinderFactory
implements BinderFactory,
DisposableBean,
ApplicationContextAware {
    private final Map<String, BinderConfiguration> binderConfigurations;
    private final Map<String, BinderInstanceHolder> binderInstanceCache = new HashMap<String, BinderInstanceHolder>();
    private volatile ConfigurableApplicationContext context;
    private Map<String, String> defaultBinderForBindingTargetType = new HashMap<String, String>();
    private Collection<Listener> listeners;
    private volatile String defaultBinder;
    private final BinderTypeRegistry binderTypeRegistry;

    public DefaultBinderFactory(Map<String, BinderConfiguration> binderConfigurations, BinderTypeRegistry binderTypeRegistry) {
        this.binderConfigurations = new HashMap<String, BinderConfiguration>(binderConfigurations);
        this.binderTypeRegistry = binderTypeRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    public void setDefaultBinder(String defaultBinder) {
        this.defaultBinder = defaultBinder;
    }

    public void setListeners(Collection<Listener> listeners) {
        this.listeners = listeners;
    }

    public void destroy() throws Exception {
        for (Map.Entry<String, BinderInstanceHolder> entry : this.binderInstanceCache.entrySet()) {
            BinderInstanceHolder binderInstanceHolder = entry.getValue();
            binderInstanceHolder.getBinderContext().close();
        }
        this.defaultBinderForBindingTargetType.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized <T> Binder<T, ?, ?> getBinder(String name, Class<? extends T> bindingTargetType) {
        String configurationName;
        block10: {
            block11: {
                block12: {
                    if (!StringUtils.isEmpty((Object)name)) break block11;
                    if (this.binderConfigurations.size() == 0) {
                        throw new IllegalStateException("A default binder has been requested, but there there is no binder available");
                    }
                    if (StringUtils.hasText((String)this.defaultBinder)) break block12;
                    HashSet<String> defaultCandidateConfigurations = new HashSet<String>();
                    for (Map.Entry<String, BinderConfiguration> binderConfigurationEntry : this.binderConfigurations.entrySet()) {
                        if (!binderConfigurationEntry.getValue().isDefaultCandidate()) continue;
                        defaultCandidateConfigurations.add(binderConfigurationEntry.getKey());
                    }
                    if (defaultCandidateConfigurations.size() == 1) {
                        configurationName = (String)defaultCandidateConfigurations.iterator().next();
                        this.defaultBinderForBindingTargetType.put(bindingTargetType.getName(), configurationName);
                        break block10;
                    } else {
                        if (defaultCandidateConfigurations.size() <= 1) {
                            throw new IllegalArgumentException("A default binder has been requested, but there is no default available");
                        }
                        ArrayList<String> candidatesForBindableType = new ArrayList<String>();
                        for (String defaultCandidateConfiguration : defaultCandidateConfigurations) {
                            Binder<T, ?, ?> binderInstance = this.getBinderInstance(defaultCandidateConfiguration);
                            Class<T> binderType = GenericsUtils.getParameterType(binderInstance.getClass(), Binder.class, 0);
                            if (!binderType.isAssignableFrom(bindingTargetType)) continue;
                            candidatesForBindableType.add(defaultCandidateConfiguration);
                        }
                        if (candidatesForBindableType.size() == 1) {
                            configurationName = (String)candidatesForBindableType.iterator().next();
                            this.defaultBinderForBindingTargetType.put(bindingTargetType.getName(), configurationName);
                            break block10;
                        } else {
                            if (candidatesForBindableType.size() > 1) {
                                throw new IllegalStateException("A default binder has been requested, but there is more than one binder available for '" + bindingTargetType.getName() + "' : " + StringUtils.collectionToCommaDelimitedString(candidatesForBindableType) + ", and no default binder has been set.");
                            }
                            throw new IllegalStateException("A default binder has been requested, but none of the registered binders can bind a '" + bindingTargetType + "': " + StringUtils.collectionToCommaDelimitedString(defaultCandidateConfigurations));
                        }
                    }
                }
                configurationName = this.defaultBinder;
                break block10;
            }
            configurationName = name;
        }
        Binder<T, ?, ?> binderInstance = this.getBinderInstance(configurationName);
        if (!GenericsUtils.getParameterType(binderInstance.getClass(), Binder.class, 0).isAssignableFrom(bindingTargetType)) {
            throw new IllegalStateException("The binder '" + configurationName + "' cannot bind a " + bindingTargetType.getName());
        }
        return binderInstance;
    }

    private <T> Binder<T, ?, ?> getBinderInstance(String configurationName) {
        if (!this.binderInstanceCache.containsKey(configurationName)) {
            boolean useApplicationContextAsParent;
            BinderConfiguration binderConfiguration = this.binderConfigurations.get(configurationName);
            if (binderConfiguration == null) {
                throw new IllegalStateException("Unknown binder configuration: " + configurationName);
            }
            BinderType binderType = this.binderTypeRegistry.get(binderConfiguration.getBinderType());
            Assert.notNull((Object)binderType, (String)("Binder type " + binderConfiguration.getBinderType() + " is not defined"));
            Properties binderProperties = binderConfiguration.getProperties();
            ArrayList<String> args = new ArrayList<String>();
            for (Map.Entry<Object, Object> property : binderProperties.entrySet()) {
                args.add(String.format("--%s=%s", property.getKey(), property.getValue()));
            }
            ConfigurableEnvironment environment = this.context != null ? this.context.getEnvironment() : null;
            String defaultDomain = environment != null ? environment.getProperty("spring.jmx.default-domain") : null;
            defaultDomain = defaultDomain == null ? "" : defaultDomain + ".";
            args.add("--spring.jmx.default-domain=" + defaultDomain + "binder." + configurationName);
            args.add("--spring.main.applicationContextClass=" + AnnotationConfigApplicationContext.class.getName());
            ArrayList configurationClasses = new ArrayList(Arrays.asList(binderType.getConfigurationClasses()));
            SpringApplicationBuilder springApplicationBuilder = new SpringApplicationBuilder(new Class[0]).sources(configurationClasses.toArray(new Class[0])).bannerMode(Banner.Mode.OFF).logStartupInfo(false).web(false);
            boolean bl = useApplicationContextAsParent = binderProperties.isEmpty() && this.context != null;
            if (useApplicationContextAsParent) {
                springApplicationBuilder.parent(this.context);
            }
            if ((useApplicationContextAsParent || environment != null && binderConfiguration.isInheritEnvironment()) && environment != null) {
                StandardEnvironment binderEnvironment = new StandardEnvironment();
                binderEnvironment.merge(environment);
                springApplicationBuilder.environment((ConfigurableEnvironment)binderEnvironment);
            }
            ConfigurableApplicationContext binderProducingContext = springApplicationBuilder.run(args.toArray(new String[args.size()]));
            Binder binder = (Binder)binderProducingContext.getBean(Binder.class);
            if (this.listeners != null) {
                for (Listener binderFactoryListener : this.listeners) {
                    binderFactoryListener.afterBinderContextInitialized(configurationName, binderProducingContext);
                }
            }
            this.binderInstanceCache.put(configurationName, new BinderInstanceHolder(binder, binderProducingContext));
        }
        return this.binderInstanceCache.get(configurationName).getBinderInstance();
    }

    private static final class BinderInstanceHolder {
        private final Binder<?, ?, ?> binderInstance;
        private final ConfigurableApplicationContext binderContext;

        private BinderInstanceHolder(Binder<?, ?, ?> binderInstance, ConfigurableApplicationContext binderContext) {
            this.binderInstance = binderInstance;
            this.binderContext = binderContext;
        }

        public Binder<?, ?, ?> getBinderInstance() {
            return this.binderInstance;
        }

        public ConfigurableApplicationContext getBinderContext() {
            return this.binderContext;
        }
    }

    public static interface Listener {
        public void afterBinderContextInitialized(String var1, ConfigurableApplicationContext var2);
    }
}

