/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import org.springframework.cloud.stream.binder.PartitionKeyExtractorStrategy;
import org.springframework.cloud.stream.binder.PartitionSelectorStrategy;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.expression.EvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class PartitionHandler {
    private final EvaluationContext evaluationContext;
    private final ProducerProperties producerProperties;
    private final PartitionKeyExtractorStrategy partitionKeyExtractorStrategy;
    private final PartitionSelectorStrategy partitionSelectorStrategy;

    public PartitionHandler(EvaluationContext evaluationContext, ProducerProperties properties, PartitionKeyExtractorStrategy partitionKeyExtractorStrategy, PartitionSelectorStrategy partitionSelectorStrategy) {
        this.evaluationContext = evaluationContext;
        this.producerProperties = properties;
        this.partitionKeyExtractorStrategy = partitionKeyExtractorStrategy;
        this.partitionSelectorStrategy = partitionSelectorStrategy;
    }

    public int determinePartition(Message<?> message) {
        Object key = this.extractKey(message);
        int partition = this.producerProperties.getPartitionSelectorExpression() != null ? ((Integer)this.producerProperties.getPartitionSelectorExpression().getValue(this.evaluationContext, key, Integer.class)).intValue() : this.partitionSelectorStrategy.selectPartition(key, this.producerProperties.getPartitionCount());
        return Math.abs(partition % this.producerProperties.getPartitionCount());
    }

    private Object extractKey(Message<?> message) {
        Object key = null;
        if (this.producerProperties.getPartitionKeyExtractorClass() != null) {
            key = this.invokeKeyExtractor(message);
        } else if (this.producerProperties.getPartitionKeyExpression() != null) {
            key = this.producerProperties.getPartitionKeyExpression().getValue(this.evaluationContext, message);
        }
        Assert.notNull((Object)key, (String)"Partition key cannot be null");
        return key;
    }

    private Object invokeKeyExtractor(Message<?> message) {
        return this.partitionKeyExtractorStrategy.extractKey(message);
    }
}

