/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.DynamicDestinationsBindable;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.BeanFactoryMessageChannelDestinationResolver;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BinderAwareChannelResolver
extends BeanFactoryMessageChannelDestinationResolver {
    private final BindingService bindingService;
    private final AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory;
    private final DynamicDestinationsBindable dynamicDestinationsBindable;
    private final NewDestinationBindingCallback newBindingCallback;
    private ConfigurableListableBeanFactory beanFactory;

    public BinderAwareChannelResolver(BindingService bindingService, AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory, DynamicDestinationsBindable dynamicDestinationsBindable) {
        this(bindingService, bindingTargetFactory, dynamicDestinationsBindable, null);
    }

    public BinderAwareChannelResolver(BindingService bindingService, AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory, DynamicDestinationsBindable dynamicDestinationsBindable, NewDestinationBindingCallback callback) {
        this.dynamicDestinationsBindable = dynamicDestinationsBindable;
        Assert.notNull((Object)bindingService, (String)"'bindingService' cannot be null");
        Assert.notNull(bindingTargetFactory, (String)"'bindingTargetFactory' cannot be null");
        this.bindingService = bindingService;
        this.bindingTargetFactory = bindingTargetFactory;
        this.newBindingCallback = callback;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel resolveDestination(String channelName) {
        try {
            return super.resolveDestination(channelName);
        }
        catch (DestinationResolutionException destinationResolutionException) {
            BinderAwareChannelResolver binderAwareChannelResolver = this;
            synchronized (binderAwareChannelResolver) {
                try {
                    return super.resolveDestination(channelName);
                }
                catch (DestinationResolutionException e) {
                    DestinationResolutionException destinationResolutionException2 = e;
                    MessageChannel channel = null;
                    if (this.beanFactory != null) {
                        boolean dynamicAllowed;
                        Object[] dynamicDestinations = null;
                        BindingServiceProperties bindingServiceProperties = this.bindingService.getBindingServiceProperties();
                        if (bindingServiceProperties != null) {
                            dynamicDestinations = bindingServiceProperties.getDynamicDestinations();
                        }
                        boolean bl = dynamicAllowed = ObjectUtils.isEmpty(dynamicDestinations) || ObjectUtils.containsElement((Object[])dynamicDestinations, (Object)channelName);
                        if (dynamicAllowed) {
                            channel = this.bindingTargetFactory.createOutput(channelName);
                            this.beanFactory.registerSingleton(channelName, (Object)channel);
                            channel = (MessageChannel)this.beanFactory.initializeBean((Object)channel, channelName);
                            if (this.newBindingCallback != null) {
                                ProducerProperties producerProperties = this.bindingService.getBindingServiceProperties().getProducerProperties(channelName);
                                Object extendedProducerProperties = this.bindingService.getExtendedProducerProperties(channel, channelName);
                                this.newBindingCallback.configure(channelName, channel, producerProperties, extendedProducerProperties);
                                this.bindingService.getBindingServiceProperties().updateProducerProperties(channelName, producerProperties);
                            }
                            Binding<MessageChannel> binding = this.bindingService.bindProducer(channel, channelName);
                            this.dynamicDestinationsBindable.addOutputBinding(channelName, binding);
                        } else {
                            throw destinationResolutionException2;
                        }
                    }
                    return channel;
                }
            }
        }
    }

    @FunctionalInterface
    public static interface NewDestinationBindingCallback<T> {
        public void configure(String var1, MessageChannel var2, ProducerProperties var3, T var4);
    }
}

