/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.PartitionKeyExtractorStrategy;
import org.springframework.cloud.stream.binder.PartitionSelectorStrategy;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.cloud.stream.binding.BinderAwareRouterBeanPostProcessor;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.CompositeMessageChannelConfigurer;
import org.springframework.cloud.stream.binding.ContextStartAfterRefreshListener;
import org.springframework.cloud.stream.binding.DynamicDestinationsBindable;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.binding.MessageChannelStreamListenerResultAdapter;
import org.springframework.cloud.stream.binding.MessageConverterConfigurer;
import org.springframework.cloud.stream.binding.MessageSourceBindingTargetFactory;
import org.springframework.cloud.stream.binding.OutputBindingLifecycle;
import org.springframework.cloud.stream.binding.SingleBindingTargetBindable;
import org.springframework.cloud.stream.binding.StreamListenerAnnotationBeanPostProcessor;
import org.springframework.cloud.stream.binding.SubscribableChannelBindingTargetFactory;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.cloud.stream.config.ContentTypeConfiguration;
import org.springframework.cloud.stream.config.SpringIntegrationProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.config.HandlerMethodArgumentResolversHolder;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableConfigurationProperties(value={BindingServiceProperties.class, SpringIntegrationProperties.class})
@Import(value={ContentTypeConfiguration.class})
@Role(value=2)
public class BindingServiceConfiguration {
    public static final String STREAM_LISTENER_ANNOTATION_BEAN_POST_PROCESSOR_NAME = "streamListenerAnnotationBeanPostProcessor";
    public static final String ERROR_BRIDGE_CHANNEL = "errorBridgeChannel";
    private static final String ERROR_KEY_NAME = "error";

    @Bean
    public MessageChannelStreamListenerResultAdapter messageChannelStreamListenerResultAdapter() {
        return new MessageChannelStreamListenerResultAdapter();
    }

    @Bean
    public static MessageHandlerMethodFactory messageHandlerMethodFactory(CompositeMessageConverterFactory compositeMessageConverterFactory, @Qualifier(value="integrationArgumentResolvers") HandlerMethodArgumentResolversHolder ahmar) {
        DefaultMessageHandlerMethodFactory messageHandlerMethodFactory = new DefaultMessageHandlerMethodFactory();
        messageHandlerMethodFactory.setMessageConverter((MessageConverter)compositeMessageConverterFactory.getMessageConverterForAllRegistered());
        messageHandlerMethodFactory.setCustomArgumentResolvers(ahmar.getResolvers());
        return messageHandlerMethodFactory;
    }

    @Bean(name={"streamListenerAnnotationBeanPostProcessor"})
    public static StreamListenerAnnotationBeanPostProcessor streamListenerAnnotationBeanPostProcessor() {
        return new StreamListenerAnnotationBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public BindingService bindingService(BindingServiceProperties bindingServiceProperties, BinderFactory binderFactory, TaskScheduler taskScheduler) {
        return new BindingService(bindingServiceProperties, binderFactory, taskScheduler);
    }

    @Bean
    public MessageConverterConfigurer messageConverterConfigurer(BindingServiceProperties bindingServiceProperties, CompositeMessageConverterFactory compositeMessageConverterFactory, @Nullable Map<String, PartitionKeyExtractorStrategy> partitionKeyExtractors, @Nullable Map<String, PartitionSelectorStrategy> partitionSelectors) {
        return new MessageConverterConfigurer(bindingServiceProperties, compositeMessageConverterFactory, partitionKeyExtractors, partitionSelectors);
    }

    @Bean
    public SubscribableChannelBindingTargetFactory channelFactory(CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        return new SubscribableChannelBindingTargetFactory(compositeMessageChannelConfigurer);
    }

    @Bean
    public MessageSourceBindingTargetFactory messageSourceFactory(CompositeMessageConverterFactory compositeMessageConverterFactory, CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        return new MessageSourceBindingTargetFactory((SmartMessageConverter)compositeMessageConverterFactory.getMessageConverterForAllRegistered(), compositeMessageChannelConfigurer);
    }

    @Bean
    @ConditionalOnMissingBean
    public CompositeMessageChannelConfigurer compositeMessageChannelConfigurer(MessageConverterConfigurer messageConverterConfigurer) {
        ArrayList<MessageChannelConfigurer> configurerList = new ArrayList<MessageChannelConfigurer>();
        configurerList.add(messageConverterConfigurer);
        return new CompositeMessageChannelConfigurer(configurerList);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public OutputBindingLifecycle outputBindingLifecycle(BindingService bindingService, Map<String, Bindable> bindables) {
        return new OutputBindingLifecycle(bindingService, bindables);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public InputBindingLifecycle inputBindingLifecycle(BindingService bindingService, Map<String, Bindable> bindables) {
        return new InputBindingLifecycle(bindingService, bindables);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public ContextStartAfterRefreshListener contextStartAfterRefreshListener() {
        return new ContextStartAfterRefreshListener();
    }

    @Bean
    public BinderAwareChannelResolver binderAwareChannelResolver(BindingService bindingService, AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory, DynamicDestinationsBindable dynamicDestinationsBindable, @Nullable BinderAwareChannelResolver.NewDestinationBindingCallback callback) {
        return new BinderAwareChannelResolver(bindingService, bindingTargetFactory, dynamicDestinationsBindable, callback);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.stream.bindings.error.destination"})
    public MessageChannel errorBridgeChannel(@Qualifier(value="errorChannel") PublishSubscribeChannel errorChannel) {
        DirectChannel errorBridgeChannel = new DirectChannel();
        BridgeHandler handler = new BridgeHandler();
        handler.setOutputChannel((MessageChannel)errorBridgeChannel);
        errorChannel.subscribe((MessageHandler)handler);
        return errorBridgeChannel;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.stream.bindings.error.destination"})
    public SingleBindingTargetBindable<MessageChannel> errorBridgeChannelBindable(@Qualifier(value="errorBridgeChannel") MessageChannel errorBridgeChannel, CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        compositeMessageChannelConfigurer.configureOutputChannel(errorBridgeChannel, ERROR_KEY_NAME);
        return new SingleBindingTargetBindable<MessageChannel>(ERROR_KEY_NAME, errorBridgeChannel);
    }

    @Bean
    public DynamicDestinationsBindable dynamicDestinationsBindable() {
        return new DynamicDestinationsBindable();
    }

    @Bean
    @Deprecated
    public ChannelBindingServiceProperties channelBindingServiceProperties(BindingServiceProperties bindingServiceProperties) {
        return new ChannelBindingServiceProperties(bindingServiceProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public BinderAwareRouterBeanPostProcessor binderAwareRouterBeanPostProcessor(@Autowired(required=false) AbstractMappingMessageRouter[] routers, @Autowired(required=false) DestinationResolver<MessageChannel> channelResolver) {
        return new BinderAwareRouterBeanPostProcessor(routers, channelResolver);
    }

    @Bean
    public static InitializingBean messageHandlerHeaderPropagationBeanPostProcessor(final @Autowired(required=false) List<AbstractReplyProducingMessageHandler> producingMessageHandlers, final @Autowired SpringIntegrationProperties springIntegrationProperties) {
        return new InitializingBean(){

            public void afterPropertiesSet() throws Exception {
                if (!CollectionUtils.isEmpty((Collection)producingMessageHandlers)) {
                    String[] messageHandlerNotPropagatedHeaders = springIntegrationProperties.getMessageHandlerNotPropagatedHeaders();
                    for (AbstractReplyProducingMessageHandler producingMessageHandler : producingMessageHandlers) {
                        producingMessageHandler.addNotPropagatedHeaders(messageHandlerNotPropagatedHeaders);
                    }
                }
            }
        };
    }
}

