/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.converter.ApplicationJsonMessageMarshallingConverter;
import org.springframework.cloud.stream.converter.ConversionException;
import org.springframework.cloud.stream.converter.JavaSerializationMessageConverter;
import org.springframework.cloud.stream.converter.JsonUnmarshallingConverter;
import org.springframework.cloud.stream.converter.KryoMessageConverter;
import org.springframework.cloud.stream.converter.ObjectStringMessageConverter;
import org.springframework.cloud.stream.converter.TupleJsonMessageConverter;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;

public class CompositeMessageConverterFactory {
    private final Log log = LogFactory.getLog(CompositeMessageConverterFactory.class);
    private final ObjectMapper objectMapper;
    private final List<MessageConverter> converters;

    public CompositeMessageConverterFactory() {
        this(Collections.emptyList(), new ObjectMapper());
    }

    public CompositeMessageConverterFactory(List<? extends MessageConverter> customConverters, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.converters = !CollectionUtils.isEmpty(customConverters) ? new ArrayList<MessageConverter>(customConverters) : new ArrayList<MessageConverter>();
        this.initDefaultConverters();
    }

    private void initDefaultConverters() {
        ApplicationJsonMessageMarshallingConverter applicationJson = new ApplicationJsonMessageMarshallingConverter();
        applicationJson.setStrictContentTypeMatch(true);
        if (this.objectMapper != null) {
            applicationJson.setObjectMapper(this.objectMapper);
        }
        this.converters.add((MessageConverter)applicationJson);
        this.converters.add((MessageConverter)new TupleJsonMessageConverter(this.objectMapper));
        this.converters.add((MessageConverter)new ByteArrayMessageConverter());
        this.converters.add((MessageConverter)new ObjectStringMessageConverter());
        this.converters.add((MessageConverter)new JavaSerializationMessageConverter());
        this.converters.add((MessageConverter)new KryoMessageConverter(null, true));
        this.converters.add((MessageConverter)new JsonUnmarshallingConverter(this.objectMapper));
    }

    public MessageConverter getMessageConverterForType(MimeType mimeType) {
        ArrayList<MessageConverter> converters = new ArrayList<MessageConverter>();
        for (MessageConverter converter : this.converters) {
            if (converter instanceof AbstractMessageConverter) {
                for (MimeType type : ((AbstractMessageConverter)converter).getSupportedMimeTypes()) {
                    if (!type.includes(mimeType)) continue;
                    converters.add(converter);
                }
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Ommitted " + converter + " of type " + converter.getClass().toString() + " for '" + mimeType.toString() + "' as it is not an AbstractMessageConverter"));
        }
        if (CollectionUtils.isEmpty(converters)) {
            throw new ConversionException("No message converter is registered for " + mimeType.toString());
        }
        if (converters.size() > 1) {
            return new CompositeMessageConverter(converters);
        }
        return (MessageConverter)converters.get(0);
    }

    public CompositeMessageConverter getMessageConverterForAllRegistered() {
        return new CompositeMessageConverter(new ArrayList<MessageConverter>(this.converters));
    }
}

