/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.util.Assert;

@Endpoint(id="bindings")
public class BindingsEndpoint {
    static final String BASE_ENPOINT_ID = "bindings";
    static final String START_ENPOINT_ID = "bindings/start/{name}";
    static final String STOP_ENPOINT_ID = "bindings/stop/{name}";
    private final List<InputBindingLifecycle> inputBindingLifecycles;
    private final ObjectMapper objectMapper;

    public BindingsEndpoint(List<InputBindingLifecycle> inputBindingLifecycles) {
        Assert.notEmpty(inputBindingLifecycles, (String)"'inputBindingLifecycles' must not be null or empty");
        this.inputBindingLifecycles = inputBindingLifecycles;
        this.objectMapper = new ObjectMapper();
    }

    @ReadOperation
    public List<?> bindings() {
        return (List)this.objectMapper.convertValue(this.gatherInputBindings(), List.class);
    }

    public StopEndpoint getStopEndpoint() {
        return new StopEndpoint();
    }

    public StartEndpoint getStartEndpoint() {
        return new StartEndpoint();
    }

    private List<Binding<?>> gatherInputBindings() {
        ArrayList inputBindings = new ArrayList();
        for (InputBindingLifecycle inputBindingLifecycle : this.inputBindingLifecycles) {
            Collection lifecycleInputBindings = (Collection)new DirectFieldAccessor((Object)inputBindingLifecycle).getPropertyValue("inputBindings");
            inputBindings.addAll(lifecycleInputBindings);
        }
        return inputBindings;
    }

    private Binding<?> locateBinding(String name) {
        return this.gatherInputBindings().stream().filter(binding -> name.equals(binding.getName())).findFirst().orElse(null);
    }

    @Endpoint(id="bindings/start/{name}")
    public class StartEndpoint {
        @WriteOperation
        public boolean start(String name) {
            Binding binding = BindingsEndpoint.this.locateBinding(name);
            if (binding != null) {
                binding.start();
            }
            return binding != null;
        }
    }

    @Endpoint(id="bindings/stop/{name}")
    public class StopEndpoint {
        @WriteOperation
        public boolean stop(String name) {
            Binding binding = BindingsEndpoint.this.locateBinding(name);
            if (binding != null) {
                binding.stop();
            }
            return binding != null;
        }
    }
}

