/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.cloud.stream.binder.DefaultPollableMessageSource;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.MessageChannelAndSourceConfigurer;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.util.Assert;

public class MessageSourceBindingTargetFactory
extends AbstractBindingTargetFactory<PollableMessageSource> {
    private final MessageChannelAndSourceConfigurer messageSourceConfigurer;
    private final SmartMessageConverter messageConverter;

    public MessageSourceBindingTargetFactory(SmartMessageConverter messageConverter, MessageChannelConfigurer messageSourceConfigurer) {
        super(PollableMessageSource.class);
        Assert.isInstanceOf(MessageChannelAndSourceConfigurer.class, (Object)messageSourceConfigurer);
        this.messageSourceConfigurer = (MessageChannelAndSourceConfigurer)messageSourceConfigurer;
        this.messageConverter = messageConverter;
    }

    @Override
    public PollableMessageSource createInput(String name) {
        DefaultPollableMessageSource binding = new DefaultPollableMessageSource(this.messageConverter);
        this.messageSourceConfigurer.configurePolledMessageSource(binding, name);
        return binding;
    }

    @Override
    public PollableMessageSource createOutput(String name) {
        throw new UnsupportedOperationException();
    }
}

