/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.DefaultBinderFactory;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.cloud.stream.binding.BinderAwareRouterBeanPostProcessor;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.ContextStartAfterRefreshListener;
import org.springframework.cloud.stream.binding.DynamicDestinationsBindable;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.cloud.stream.binding.MessageChannelStreamListenerResultAdapter;
import org.springframework.cloud.stream.binding.OutputBindingLifecycle;
import org.springframework.cloud.stream.binding.StreamListenerAnnotationBeanPostProcessor;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingHandlerAdvise;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.config.SpelExpressionConverterConfiguration;
import org.springframework.cloud.stream.config.SpringIntegrationProperties;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.cloud.stream.micrometer.DestinationPublishingMetricsAutoConfiguration;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Configuration
@EnableConfigurationProperties(value={BindingServiceProperties.class, SpringIntegrationProperties.class, StreamFunctionProperties.class})
@Import(value={DestinationPublishingMetricsAutoConfiguration.class, SpelExpressionConverterConfiguration.class})
@Role(value=2)
@ConditionalOnBean(value={BinderTypeRegistry.class}, search=SearchStrategy.CURRENT)
public class BindingServiceConfiguration {
    public static final String STREAM_LISTENER_ANNOTATION_BEAN_POST_PROCESSOR_NAME = "streamListenerAnnotationBeanPostProcessor";
    @Autowired(required=false)
    private Collection<DefaultBinderFactory.Listener> binderFactoryListeners;

    @Bean
    public BindingHandlerAdvise BindingHandlerAdvise(@Nullable BindingHandlerAdvise.MappingsProvider[] providers) {
        HashMap<ConfigurationPropertyName, ConfigurationPropertyName> additionalMappings = new HashMap<ConfigurationPropertyName, ConfigurationPropertyName>();
        if (!ObjectUtils.isEmpty((Object[])providers)) {
            for (int i = 0; i < providers.length; ++i) {
                BindingHandlerAdvise.MappingsProvider mappingsProvider = providers[i];
                additionalMappings.putAll(mappingsProvider.getDefaultMappings());
            }
        }
        return new BindingHandlerAdvise(additionalMappings);
    }

    @Bean
    @ConditionalOnMissingBean(value={BinderFactory.class})
    public BinderFactory binderFactory(BinderTypeRegistry binderTypeRegistry, BindingServiceProperties bindingServiceProperties) {
        DefaultBinderFactory binderFactory = new DefaultBinderFactory(BindingServiceConfiguration.getBinderConfigurations(binderTypeRegistry, bindingServiceProperties), binderTypeRegistry);
        binderFactory.setDefaultBinder(bindingServiceProperties.getDefaultBinder());
        binderFactory.setListeners(this.binderFactoryListeners);
        return binderFactory;
    }

    private static Map<String, BinderConfiguration> getBinderConfigurations(BinderTypeRegistry binderTypeRegistry, BindingServiceProperties bindingServiceProperties) {
        HashMap<String, BinderConfiguration> binderConfigurations = new HashMap<String, BinderConfiguration>();
        Map<String, BinderProperties> declaredBinders = bindingServiceProperties.getBinders();
        boolean defaultCandidatesExist = false;
        Iterator<Map.Entry<String, BinderProperties>> binderPropertiesIterator = declaredBinders.entrySet().iterator();
        while (!defaultCandidatesExist && binderPropertiesIterator.hasNext()) {
            defaultCandidatesExist = binderPropertiesIterator.next().getValue().isDefaultCandidate();
        }
        ArrayList<String> existingBinderConfigurations = new ArrayList<String>();
        for (Map.Entry<String, BinderProperties> entry : declaredBinders.entrySet()) {
            BinderProperties binderProperties = entry.getValue();
            if (binderTypeRegistry.get(entry.getKey()) != null) {
                binderConfigurations.put(entry.getKey(), new BinderConfiguration(entry.getKey(), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
                existingBinderConfigurations.add(entry.getKey());
                continue;
            }
            Assert.hasText((String)binderProperties.getType(), (String)("No 'type' property present for custom binder " + entry.getKey()));
            binderConfigurations.put(entry.getKey(), new BinderConfiguration(binderProperties.getType(), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
            existingBinderConfigurations.add(entry.getKey());
        }
        for (Map.Entry<String, BinderProperties> entry : binderConfigurations.entrySet()) {
            if (!((BinderConfiguration)((Object)entry.getValue())).isDefaultCandidate()) continue;
            defaultCandidatesExist = true;
        }
        if (!defaultCandidatesExist) {
            for (Map.Entry<String, Object> entry : binderTypeRegistry.getAll().entrySet()) {
                if (existingBinderConfigurations.contains(entry.getKey())) continue;
                binderConfigurations.put(entry.getKey(), new BinderConfiguration(entry.getKey(), new HashMap<String, Object>(), true, true));
            }
        }
        return binderConfigurations;
    }

    @Bean
    public MessageChannelStreamListenerResultAdapter messageChannelStreamListenerResultAdapter() {
        return new MessageChannelStreamListenerResultAdapter();
    }

    @Bean(name={"streamListenerAnnotationBeanPostProcessor"})
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public static StreamListenerAnnotationBeanPostProcessor streamListenerAnnotationBeanPostProcessor() {
        return new StreamListenerAnnotationBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public BindingService bindingService(BindingServiceProperties bindingServiceProperties, BinderFactory binderFactory, TaskScheduler taskScheduler) {
        return new BindingService(bindingServiceProperties, binderFactory, taskScheduler);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public OutputBindingLifecycle outputBindingLifecycle(BindingService bindingService, Map<String, Bindable> bindables) {
        return new OutputBindingLifecycle(bindingService, bindables);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public InputBindingLifecycle inputBindingLifecycle(BindingService bindingService, Map<String, Bindable> bindables) {
        return new InputBindingLifecycle(bindingService, bindables);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public ContextStartAfterRefreshListener contextStartAfterRefreshListener() {
        return new ContextStartAfterRefreshListener();
    }

    @Bean
    public BinderAwareChannelResolver binderAwareChannelResolver(BindingService bindingService, AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory, DynamicDestinationsBindable dynamicDestinationsBindable, @Nullable BinderAwareChannelResolver.NewDestinationBindingCallback callback) {
        return new BinderAwareChannelResolver(bindingService, bindingTargetFactory, dynamicDestinationsBindable, callback);
    }

    @Bean
    public DynamicDestinationsBindable dynamicDestinationsBindable() {
        return new DynamicDestinationsBindable();
    }

    @Bean
    @ConditionalOnMissingBean
    public BinderAwareRouterBeanPostProcessor binderAwareRouterBeanPostProcessor(@Autowired(required=false) AbstractMappingMessageRouter[] routers, @Autowired(required=false) DestinationResolver<MessageChannel> channelResolver) {
        return new BinderAwareRouterBeanPostProcessor(routers, channelResolver);
    }

    @Bean
    public ApplicationListener<ContextRefreshedEvent> appListener(final SpringIntegrationProperties springIntegrationProperties) {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                event.getApplicationContext().getBeansOfType(AbstractReplyProducingMessageHandler.class).values().forEach(mh -> mh.addNotPropagatedHeaders(springIntegrationProperties.getMessageHandlerNotPropagatedHeaders()));
            }
        };
    }
}

