/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.DefaultBinderTypeRegistry;
import org.springframework.cloud.stream.binding.BindableProxyFactory;
import org.springframework.cloud.stream.binding.CompositeMessageChannelConfigurer;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.binding.MessageConverterConfigurer;
import org.springframework.cloud.stream.binding.MessageSourceBindingTargetFactory;
import org.springframework.cloud.stream.binding.SubscribableChannelBindingTargetFactory;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.config.ContentTypeConfiguration;
import org.springframework.cloud.stream.config.SmartMessageMethodArgumentResolver;
import org.springframework.cloud.stream.config.SmartPayloadArgumentResolver;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.messaging.Processor;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.integration.handler.support.MapArgumentResolver;
import org.springframework.integration.handler.support.PayloadExpressionArgumentResolver;
import org.springframework.integration.handler.support.PayloadsArgumentResolver;
import org.springframework.integration.support.NullAwarePayloadArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Validator;

@Configuration
@Role(value=2)
@EnableConfigurationProperties(value={BindingServiceProperties.class})
@Import(value={ContentTypeConfiguration.class})
@Deprecated
public class BinderFactoryConfiguration {
    private static final String SPRING_CLOUD_STREAM_INTERNAL_PREFIX = "spring.cloud.stream.internal";
    private static final String SELF_CONTAINED_APP_PROPERTY_NAME = "spring.cloud.stream.internal.selfContained";
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Value(value="${spring.cloud.stream.internal.selfContained:}")
    private String selfContained;

    static Collection<BinderType> parseBinderConfigurations(ClassLoader classLoader, Resource resource) throws IOException, ClassNotFoundException {
        Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
        ArrayList<BinderType> parsedBinderConfigurations = new ArrayList<BinderType>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String binderType = (String)entry.getKey();
            String[] binderConfigurationClassNames = StringUtils.commaDelimitedListToStringArray((String)((String)entry.getValue()));
            Class[] binderConfigurationClasses = new Class[binderConfigurationClassNames.length];
            int i = 0;
            for (String binderConfigurationClassName : binderConfigurationClassNames) {
                binderConfigurationClasses[i++] = ClassUtils.forName((String)binderConfigurationClassName, (ClassLoader)classLoader);
            }
            parsedBinderConfigurations.add(new BinderType(binderType, binderConfigurationClasses));
        }
        return parsedBinderConfigurations;
    }

    @Bean(value={"integrationMessageHandlerMethodFactory"})
    public static MessageHandlerMethodFactory messageHandlerMethodFactory(CompositeMessageConverterFactory compositeMessageConverterFactory, @Nullable Validator validator, ConfigurableListableBeanFactory clbf) {
        DefaultMessageHandlerMethodFactory messageHandlerMethodFactory = new DefaultMessageHandlerMethodFactory();
        CompositeMessageConverter messageConverter = compositeMessageConverterFactory.getMessageConverterForAllRegistered();
        messageHandlerMethodFactory.setMessageConverter((MessageConverter)messageConverter);
        LinkedList<Object> resolvers = new LinkedList<Object>();
        resolvers.add((Object)new SmartPayloadArgumentResolver((MessageConverter)messageConverter, validator));
        resolvers.add((Object)new SmartMessageMethodArgumentResolver((MessageConverter)messageConverter));
        resolvers.add(new HeaderMethodArgumentResolver(null, (ConfigurableBeanFactory)clbf));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new PayloadExpressionArgumentResolver());
        resolvers.add(new NullAwarePayloadArgumentResolver((MessageConverter)messageConverter));
        PayloadExpressionArgumentResolver payloadExpressionArgumentResolver = new PayloadExpressionArgumentResolver();
        payloadExpressionArgumentResolver.setBeanFactory((BeanFactory)clbf);
        resolvers.add(payloadExpressionArgumentResolver);
        PayloadsArgumentResolver payloadsArgumentResolver = new PayloadsArgumentResolver();
        payloadsArgumentResolver.setBeanFactory((BeanFactory)clbf);
        resolvers.add(payloadsArgumentResolver);
        MapArgumentResolver mapArgumentResolver = new MapArgumentResolver();
        mapArgumentResolver.setBeanFactory((BeanFactory)clbf);
        resolvers.add(mapArgumentResolver);
        messageHandlerMethodFactory.setArgumentResolvers(resolvers);
        messageHandlerMethodFactory.setValidator(validator);
        return messageHandlerMethodFactory;
    }

    @Bean
    public BinderTypeRegistry binderTypeRegistry(ConfigurableApplicationContext configurableApplicationContext) {
        HashMap<String, BinderType> binderTypes = new HashMap<String, BinderType>();
        ClassLoader classLoader = configurableApplicationContext.getClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/spring.binders");
            if (!(Boolean.valueOf(this.selfContained).booleanValue() || resources != null && resources.hasMoreElements())) {
                this.logger.debug((Object)"Failed to locate 'META-INF/spring.binders' resources on the classpath. Assuming standard boot 'META-INF/spring.factories' configuration is used");
            } else {
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    UrlResource resource = new UrlResource(url);
                    for (BinderType binderType : BinderFactoryConfiguration.parseBinderConfigurations(classLoader, (Resource)resource)) {
                        binderTypes.put(binderType.getDefaultName(), binderType);
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new BeanCreationException("Cannot create binder factory:", (Throwable)e);
        }
        return new DefaultBinderTypeRegistry(binderTypes);
    }

    @Bean
    public MessageConverterConfigurer messageConverterConfigurer(BindingServiceProperties bindingServiceProperties, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        return new MessageConverterConfigurer(bindingServiceProperties, compositeMessageConverterFactory);
    }

    @Bean
    public SubscribableChannelBindingTargetFactory channelFactory(CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        return new SubscribableChannelBindingTargetFactory(compositeMessageChannelConfigurer);
    }

    @Bean
    public MessageSourceBindingTargetFactory messageSourceFactory(CompositeMessageConverterFactory compositeMessageConverterFactory, CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        return new MessageSourceBindingTargetFactory((SmartMessageConverter)compositeMessageConverterFactory.getMessageConverterForAllRegistered(), compositeMessageChannelConfigurer);
    }

    @Bean
    public CompositeMessageChannelConfigurer compositeMessageChannelConfigurer(MessageConverterConfigurer messageConverterConfigurer) {
        ArrayList<MessageChannelConfigurer> configurerList = new ArrayList<MessageChannelConfigurer>();
        configurerList.add(messageConverterConfigurer);
        return new CompositeMessageChannelConfigurer(configurerList);
    }

    @Bean
    public BeanFactoryPostProcessor implicitFunctionBinder(final Environment environment, final @Nullable FunctionRegistry functionCatalog, final @Nullable FunctionInspector inspector) {
        return new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                if (functionCatalog != null && ObjectUtils.isEmpty((Object[])beanFactory.getBeanNamesForAnnotation(EnableBinding.class))) {
                    BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                    String name = BinderFactoryConfiguration.this.determineFunctionName((FunctionCatalog)functionCatalog, environment);
                    if (StringUtils.hasText((String)name)) {
                        Object definedFunction = functionCatalog.lookup(name);
                        Class inputType = inspector.getInputType(definedFunction);
                        Class outputType = inspector.getOutputType(definedFunction);
                        if (Void.class.isAssignableFrom(outputType)) {
                            BinderFactoryConfiguration.this.bind(Sink.class, registry);
                        } else if (Void.class.isAssignableFrom(inputType)) {
                            BinderFactoryConfiguration.this.bind(Source.class, registry);
                        } else {
                            BinderFactoryConfiguration.this.bind(Processor.class, registry);
                        }
                    }
                }
            }
        };
    }

    private String determineFunctionName(FunctionCatalog catalog, Environment environment) {
        String name = environment.getProperty("spring.cloud.stream.function.definition");
        if (!StringUtils.hasText((String)name) && catalog.size() == 0) {
            ((SmartInitializingSingleton)catalog).afterSingletonsInstantiated();
        }
        if (!StringUtils.hasText((String)name) && Boolean.parseBoolean(environment.getProperty("spring.cloud.function.routing.enabled", "false"))) {
            name = "router";
        }
        if (!StringUtils.hasText((String)name) && catalog.size() >= 1 && catalog.size() <= 2) {
            name = ((FunctionInspector)catalog).getName(catalog.lookup(""));
        }
        if (StringUtils.hasText((String)name)) {
            ((StandardEnvironment)environment).getSystemProperties().putIfAbsent("spring.cloud.stream.function.definition", name);
        }
        return name;
    }

    private void bind(Class<?> type, BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(type.getName())) {
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(BindableProxyFactory.class);
            rootBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue(type);
            registry.registerBeanDefinition(type.getName(), (BeanDefinition)rootBeanDefinition);
        }
    }
}

