/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import javax.validation.constraints.AssertTrue;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.validation.annotation.Validated;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@Validated
public class BindingProperties {
    public static final MimeType DEFAULT_CONTENT_TYPE = MimeTypeUtils.APPLICATION_JSON;
    private static final String COMMA = ",";
    private String errorHandlerDefinition;
    private String destination;
    private String group;
    private String contentType = DEFAULT_CONTENT_TYPE.toString();
    private String binder;
    private ConsumerProperties consumer;
    private ProducerProperties producer;

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getBinder() {
        return this.binder;
    }

    public void setBinder(String binder) {
        this.binder = binder;
    }

    public ConsumerProperties getConsumer() {
        return this.consumer;
    }

    public void setConsumer(ConsumerProperties consumer) {
        this.consumer = consumer;
    }

    public ProducerProperties getProducer() {
        return this.producer;
    }

    public void setProducer(ProducerProperties producer) {
        this.producer = producer;
    }

    @AssertTrue(message="A binding must not set both producer and consumer properties.")
    public @AssertTrue(message="A binding must not set both producer and consumer properties.") boolean onlyOneOfProducerOrConsumerSet() {
        return this.consumer == null || this.producer == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("destination=" + this.destination);
        sb.append(COMMA);
        sb.append("group=" + this.group);
        sb.append(COMMA);
        if (this.contentType != null) {
            sb.append("contentType=" + this.contentType);
            sb.append(COMMA);
        }
        if (this.binder != null) {
            sb.append("binder=" + this.binder);
            sb.append(COMMA);
        }
        sb.deleteCharAt(sb.lastIndexOf(COMMA));
        return "BindingProperties{" + sb.toString() + "}";
    }

    public String getErrorHandlerDefinition() {
        return this.errorHandlerDefinition;
    }

    public void setErrorHandlerDefinition(String errorHandlerDefinition) {
        this.errorHandlerDefinition = errorHandlerDefinition;
    }
}

