/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.stream.function")
public class StreamFunctionProperties {
    private String definition;
    private BindingServiceProperties bindingServiceProperties;
    private Map<String, String> bindings = new HashMap<String, String>();
    private boolean batchMode;
    private boolean composeTo;
    private boolean composeFrom;
    private Map<String, Boolean> reactive = new HashMap<String, Boolean>();

    public boolean isComposeTo() {
        return this.composeTo;
    }

    public boolean isComposeFrom() {
        return this.composeFrom;
    }

    public String getDefinition() {
        return this.definition;
    }

    public List<String> getOutputBindings(String functionName) {
        return this.filterBindings(functionName, "-out-");
    }

    public List<String> getInputBindings(String functionName) {
        return this.filterBindings(functionName, "-in-");
    }

    void setDefinition(String definition) {
        if (StringUtils.hasText((String)definition)) {
            this.composeFrom = definition.startsWith("|");
            this.composeTo = definition.endsWith("|");
            this.definition = this.composeFrom ? definition.substring(1) : (this.composeTo ? definition.substring(0, definition.length() - 1) : definition);
        }
    }

    BindingServiceProperties getBindingServiceProperties() {
        return this.bindingServiceProperties;
    }

    void setBindingServiceProperties(BindingServiceProperties bindingServiceProperties) {
        this.bindingServiceProperties = bindingServiceProperties;
    }

    public Map<String, String> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, String> bindings) {
        this.bindings = bindings;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }

    private List<String> filterBindings(String functionName, String suffix) {
        List<String> list = this.bindings.keySet().stream().filter(bKey -> bKey.contains(functionName + suffix)).sorted().map(bKey -> this.bindings.get(bKey)).collect(Collectors.toList());
        return list;
    }

    public Map<String, Boolean> getReactive() {
        return this.reactive;
    }

    public void setReactive(Map<String, Boolean> reactive) {
        this.reactive = reactive;
    }
}

