/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Objects;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.vault.config.HealthBuilderDelegate;
import org.springframework.lang.Nullable;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.support.VaultHealth;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class VaultReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final ReactiveVaultOperations vaultOperations;

    public VaultReactiveHealthIndicator(ReactiveVaultOperations vaultOperations) {
        this.vaultOperations = vaultOperations;
    }

    private static Mono<? extends VaultHealthImpl> deserializeError(WebClientResponseException e) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return Mono.just((Object)((VaultHealthImpl)mapper.readValue(e.getResponseBodyAsByteArray(), VaultHealthImpl.class)));
        }
        catch (Exception jsonError) {
            UndeclaredThrowableException t = new UndeclaredThrowableException(jsonError);
            t.addSuppressed((Throwable)e);
            return Mono.error((Throwable)t);
        }
    }

    private static Health getHealth(Health.Builder builder, VaultHealthImpl vaultHealthResponse) {
        HealthBuilderDelegate.contributeToHealth(vaultHealthResponse, builder);
        return builder.build();
    }

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return ((Mono)this.vaultOperations.doWithSession(it -> it.get().uri("sys/health", new Object[0]).header("X-Vault-Namespace", new String[]{""}).exchange())).flatMap(it -> it.bodyToMono(VaultHealthImpl.class)).onErrorResume(WebClientResponseException.class, VaultReactiveHealthIndicator::deserializeError).map(vaultHealthResponse -> VaultReactiveHealthIndicator.getHealth(builder, vaultHealthResponse));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VaultHealthImpl
    implements VaultHealth {
        private final boolean initialized;
        private final boolean sealed;
        private final boolean standby;
        private final boolean performanceStandby;
        private final boolean replicationRecoverySecondary;
        private final int serverTimeUtc;
        @Nullable
        private final String version;

        VaultHealthImpl(@JsonProperty(value="initialized") boolean initialized, @JsonProperty(value="sealed") boolean sealed, @JsonProperty(value="standby") boolean standby, @JsonProperty(value="performance_standby") boolean performanceStandby, @Nullable @JsonProperty(value="replication_dr_mode") String replicationRecoverySecondary, @JsonProperty(value="server_time_utc") int serverTimeUtc, @Nullable @JsonProperty(value="version") String version) {
            this.initialized = initialized;
            this.sealed = sealed;
            this.standby = standby;
            this.performanceStandby = performanceStandby;
            this.replicationRecoverySecondary = replicationRecoverySecondary != null && !"disabled".equalsIgnoreCase(replicationRecoverySecondary);
            this.serverTimeUtc = serverTimeUtc;
            this.version = version;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public boolean isSealed() {
            return this.sealed;
        }

        public boolean isStandby() {
            return this.standby;
        }

        public boolean isPerformanceStandby() {
            return this.performanceStandby;
        }

        public boolean isRecoveryReplicationSecondary() {
            return this.replicationRecoverySecondary;
        }

        public int getServerTimeUtc() {
            return this.serverTimeUtc;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VaultHealthImpl)) {
                return false;
            }
            VaultHealthImpl that = (VaultHealthImpl)o;
            return this.initialized == that.initialized && this.sealed == that.sealed && this.standby == that.standby && this.performanceStandby == that.performanceStandby && this.replicationRecoverySecondary == that.replicationRecoverySecondary && this.serverTimeUtc == that.serverTimeUtc && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.initialized, this.sealed, this.standby, this.performanceStandby, this.replicationRecoverySecondary, this.serverTimeUtc, this.version);
        }
    }
}

