/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;

@ConfigurationProperties(value="spring.cloud.zookeeper.discovery")
public class ZookeeperDiscoveryProperties {
    private InetUtils.HostInfo hostInfo;
    private boolean enabled = true;
    private String root = "/services";
    private String uriSpec = "{scheme}://{address}:{port}";
    private String instanceHost;
    private Integer instancePort;
    private boolean register = true;
    private Map<String, String> metadata = new HashMap<String, String>();

    private ZookeeperDiscoveryProperties() {
    }

    public ZookeeperDiscoveryProperties(InetUtils inetUtils) {
        this.hostInfo = inetUtils.findFirstNonLoopbackHostInfo();
        this.instanceHost = this.hostInfo.getIpAddress();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getRoot() {
        return this.root;
    }

    public String getUriSpec() {
        return this.uriSpec;
    }

    public String getInstanceHost() {
        return this.instanceHost;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setUriSpec(String uriSpec) {
        this.uriSpec = uriSpec;
    }

    public void setInstanceHost(String instanceHost) {
        this.instanceHost = instanceHost;
        this.hostInfo.override = true;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean isRegister() {
        return this.register;
    }

    public void setRegister(boolean register) {
        this.register = register;
    }

    public Integer getInstancePort() {
        return this.instancePort;
    }

    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    public String toString() {
        return "ZookeeperDiscoveryProperties{enabled=" + this.enabled + ", root='" + this.root + '\'' + ", uriSpec='" + this.uriSpec + '\'' + ", instanceHost='" + this.instanceHost + '\'' + ", instancePort='" + this.instancePort + '\'' + ", metadata=" + this.metadata + ", register=" + this.register + '}';
    }
}

