/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading;

import cascading.cascade.Cascade;
import cascading.cascade.CascadeConnector;
import cascading.cascade.CascadeDef;
import cascading.cascade.CascadeListener;
import cascading.cascade.CascadeProps;
import cascading.flow.Flow;
import cascading.flow.FlowSkipStrategy;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CascadeFactoryBean
implements InitializingBean,
BeanNameAware,
FactoryBean<Cascade> {
    private Configuration configuration;
    private Properties properties;
    private FlowSkipStrategy skipStrategy;
    private Collection<Flow> flows;
    private int concurrentFlows = -1;
    private String beanName;
    private Collection<CascadeListener> listeners;
    private Cascade cascade;
    private CascadeDef def;

    public Cascade getObject() throws Exception {
        return this.cascade;
    }

    public Class<?> getObjectType() {
        return this.cascade != null ? this.cascade.getClass() : Cascade.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Properties props = ConfigurationUtils.asProperties((Configuration)ConfigurationUtils.createFrom((Configuration)this.configuration, (Properties)this.properties));
        CascadeDef cascadeDef = CascadeDef.cascadeDef();
        if (this.def != null) {
            ((CascadeDef)cascadeDef.addFlows(this.def.getFlows()).setName(this.def.getName())).setMaxConcurrentFlows(this.def.getMaxConcurrentFlows()).addTags(StringUtils.commaDelimitedListToStringArray((String)this.def.getTags()));
        }
        if (this.concurrentFlows != -1) {
            CascadeProps.setMaxConcurrentFlows((Map)props, (int)this.concurrentFlows);
            cascadeDef.setMaxConcurrentFlows(this.concurrentFlows);
        }
        cascadeDef.addFlows(this.flows);
        if (!StringUtils.hasText((String)cascadeDef.getName())) {
            cascadeDef.setName(this.beanName);
        }
        this.cascade = new CascadeConnector((Map)this.properties).connect(cascadeDef);
        if (this.skipStrategy != null) {
            this.cascade.setFlowSkipStrategy(this.skipStrategy);
        }
        if (!CollectionUtils.isEmpty(this.listeners)) {
            for (CascadeListener listener : this.listeners) {
                this.cascade.addListener(listener);
            }
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setFlows(Collection<Flow> flows) {
        this.flows = flows;
    }

    public void setDefinition(CascadeDef def) {
        this.def = def;
    }

    public void setListeners(Collection<CascadeListener> listeners) {
        this.listeners = listeners;
    }
}

