/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading;

import cascading.flow.Flow;
import cascading.flow.FlowListener;
import cascading.flow.FlowSkipStrategy;
import cascading.flow.FlowStepStrategy;
import java.util.Collection;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

abstract class FlowFactoryBean<T extends Flow<?>>
implements InitializingBean,
FactoryBean<T> {
    private FlowSkipStrategy skipStrategy;
    private FlowStepStrategy stepStrategy;
    private Collection<FlowListener> listeners;
    private Integer priority;
    private String writeDOT;
    private String writeStepsDOT;
    private T flow;

    FlowFactoryBean() {
    }

    public T getObject() throws Exception {
        return this.flow;
    }

    public Class<?> getObjectType() {
        return this.flow != null ? this.flow.getClass() : Flow.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.flow = this.createFlow();
        if (this.skipStrategy != null) {
            this.flow.setFlowSkipStrategy(this.skipStrategy);
        }
        if (this.stepStrategy != null) {
            this.flow.setFlowStepStrategy(this.stepStrategy);
        }
        if (this.listeners != null) {
            for (FlowListener listener : this.listeners) {
                this.flow.addListener(listener);
            }
        }
        if (StringUtils.hasText((String)this.writeDOT)) {
            this.flow.writeDOT(this.writeDOT);
        }
        if (StringUtils.hasText((String)this.writeStepsDOT)) {
            this.flow.writeStepsDOT(this.writeStepsDOT);
        }
        if (this.priority != null) {
            this.flow.setSubmitPriority(this.priority.intValue());
        }
    }

    abstract T createFlow() throws Exception;

    public void setSkipStrategy(FlowSkipStrategy skipStrategy) {
        this.skipStrategy = skipStrategy;
    }

    public void setStepStrategy(FlowStepStrategy stepStrategy) {
        this.stepStrategy = stepStrategy;
    }

    public void setListeners(Collection<FlowListener> listeners) {
        this.listeners = listeners;
    }

    public void setWriteDOT(String writeDOT) {
        this.writeDOT = writeDOT;
    }

    public void setWriteStepsDOT(String writeStepsDOT) {
        this.writeStepsDOT = writeStepsDOT;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }
}

