/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading.tap.local;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.data.hadoop.cascading.tap.local.TransformingMessageSource;
import org.springframework.integration.Message;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.transformer.Transformer;

class MessageSourceInputStream
extends InputStream {
    private final MessageSource<byte[]> source;
    private volatile byte[] currentPayload;
    private volatile int index = 0;

    MessageSourceInputStream(MessageSource<byte[]> source) {
        this.source = source;
    }

    MessageSourceInputStream(MessageSource<?> source, Transformer transformer) {
        this.source = new TransformingMessageSource<byte[]>(source, transformer);
    }

    @Override
    public int read() throws IOException {
        if (this.currentPayload == null || this.index >= this.currentPayload.length) {
            Message msg = this.source.receive();
            if (msg != null) {
                this.currentPayload = (byte[])msg.getPayload();
                this.index = 0;
            } else {
                return -1;
            }
        }
        return this.currentPayload[this.index++] & 0xFF;
    }

    public String toString() {
        return "InputStream for " + this.source;
    }
}

