/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cassandra.core.PreparedStatementCreator;
import org.springframework.util.Assert;

public class CachedPreparedStatementCreator
implements PreparedStatementCreator {
    private static final Logger log = LoggerFactory.getLogger(CachedPreparedStatementCreator.class);
    private final String cql;
    private static final Map<Session, Map<String, PreparedStatement>> psMap = new ConcurrentHashMap<Session, Map<String, PreparedStatement>>();

    public CachedPreparedStatementCreator(String cql) {
        Assert.notNull((Object)cql, (String)"CQL is required to create a PreparedStatement");
        this.cql = cql;
    }

    public String getCql() {
        return this.cql;
    }

    @Override
    public PreparedStatement createPreparedStatement(Session session) throws DriverException {
        PreparedStatement pstmt;
        StringBuilder keyspaceCQLKey = new StringBuilder().append(session.getLoggedKeyspace()).append("|").append(this.cql);
        log.debug(String.format("Cachable PreparedStatement in Keyspace [%s]", session.getLoggedKeyspace()));
        Map<String, PreparedStatement> sessionMap = psMap.get(session);
        if (sessionMap == null) {
            sessionMap = new ConcurrentHashMap<String, PreparedStatement>();
            psMap.put(session, sessionMap);
        }
        if ((pstmt = sessionMap.get(keyspaceCQLKey.toString())) == null) {
            log.debug("No Cached PreparedStatement found...Creating and Caching");
            pstmt = session.prepare(this.cql);
            sessionMap.put(keyspaceCQLKey.toString(), pstmt);
        } else {
            log.debug("Found cached PreparedStatement");
        }
        return pstmt;
    }
}

