/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.keyspace;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.cassandra.core.keyspace.TableNameSpecification;
import org.springframework.cassandra.core.keyspace.TableOption;

public abstract class TableOptionsSpecification<T extends TableOptionsSpecification<T>>
extends TableNameSpecification<TableOptionsSpecification<T>> {
    protected Map<String, Object> options = new LinkedHashMap<String, Object>();

    @Override
    public T name(String name) {
        return (T)((TableOptionsSpecification)super.name(name));
    }

    @Override
    public T name(CqlIdentifier name) {
        return (T)((TableOptionsSpecification)super.name(name));
    }

    public T with(TableOption option) {
        return this.with(option, null);
    }

    public T with(TableOption option, Object value) {
        option.checkValue(value);
        return this.with(option.getName(), value, option.escapesValue(), option.quotesValue());
    }

    public T with(String name, Object value, boolean escape, boolean quote) {
        if (!(value instanceof Map)) {
            if (escape) {
                value = CqlStringUtils.escapeSingle(value);
            }
            if (quote) {
                value = CqlStringUtils.singleQuote(value);
            }
        }
        this.options.put(name, value);
        return (T)this;
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }
}

