/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.support;

import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import org.springframework.cassandra.support.exception.CassandraAuthenticationException;
import org.springframework.cassandra.support.exception.CassandraConnectionFailureException;
import org.springframework.cassandra.support.exception.CassandraInsufficientReplicasAvailableException;
import org.springframework.cassandra.support.exception.CassandraInternalException;
import org.springframework.cassandra.support.exception.CassandraInvalidConfigurationInQueryException;
import org.springframework.cassandra.support.exception.CassandraInvalidQueryException;
import org.springframework.cassandra.support.exception.CassandraKeyspaceExistsException;
import org.springframework.cassandra.support.exception.CassandraQuerySyntaxException;
import org.springframework.cassandra.support.exception.CassandraReadTimeoutException;
import org.springframework.cassandra.support.exception.CassandraTableExistsException;
import org.springframework.cassandra.support.exception.CassandraTraceRetrievalException;
import org.springframework.cassandra.support.exception.CassandraTruncateException;
import org.springframework.cassandra.support.exception.CassandraTypeMismatchException;
import org.springframework.cassandra.support.exception.CassandraUnauthorizedException;
import org.springframework.cassandra.support.exception.CassandraUncategorizedException;
import org.springframework.cassandra.support.exception.CassandraWriteTimeoutException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public class CassandraExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException x) {
        if (x instanceof DataAccessException) {
            return (DataAccessException)((Object)x);
        }
        if (!(x instanceof DriverException)) {
            return null;
        }
        if (x instanceof AuthenticationException) {
            return new CassandraAuthenticationException(((AuthenticationException)x).getHost(), x.getMessage(), x);
        }
        if (x instanceof DriverInternalError) {
            return new CassandraInternalException(x.getMessage(), x);
        }
        if (x instanceof InvalidTypeException) {
            return new CassandraTypeMismatchException(x.getMessage(), x);
        }
        if (x instanceof NoHostAvailableException) {
            return new CassandraConnectionFailureException(((NoHostAvailableException)x).getErrors(), x.getMessage(), x);
        }
        if (x instanceof ReadTimeoutException) {
            return new CassandraReadTimeoutException(((ReadTimeoutException)x).wasDataRetrieved(), x.getMessage(), x);
        }
        if (x instanceof WriteTimeoutException) {
            WriteType writeType = ((WriteTimeoutException)x).getWriteType();
            return new CassandraWriteTimeoutException(writeType == null ? null : writeType.name(), x.getMessage(), x);
        }
        if (x instanceof TruncateException) {
            return new CassandraTruncateException(x.getMessage(), x);
        }
        if (x instanceof UnavailableException) {
            UnavailableException ux = (UnavailableException)x;
            return new CassandraInsufficientReplicasAvailableException(ux.getRequiredReplicas(), ux.getAliveReplicas(), x.getMessage(), x);
        }
        if (x instanceof AlreadyExistsException) {
            AlreadyExistsException aex = (AlreadyExistsException)x;
            return aex.wasTableCreation() ? new CassandraTableExistsException(aex.getTable(), x.getMessage(), x) : new CassandraKeyspaceExistsException(aex.getKeyspace(), x.getMessage(), x);
        }
        if (x instanceof InvalidConfigurationInQueryException) {
            return new CassandraInvalidConfigurationInQueryException(x.getMessage(), x);
        }
        if (x instanceof InvalidQueryException) {
            return new CassandraInvalidQueryException(x.getMessage(), x);
        }
        if (x instanceof SyntaxError) {
            return new CassandraQuerySyntaxException(x.getMessage(), x);
        }
        if (x instanceof UnauthorizedException) {
            return new CassandraUnauthorizedException(x.getMessage(), x);
        }
        if (x instanceof TraceRetrievalException) {
            return new CassandraTraceRetrievalException(x.getMessage(), x);
        }
        return new CassandraUncategorizedException(x.getMessage(), x);
    }
}

