/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.policies.AddressTranslator;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cassandra.config.ClusterBuilderConfigurer;
import org.springframework.cassandra.config.CompressionType;
import org.springframework.cassandra.core.CqlTemplate;
import org.springframework.cassandra.core.cql.generator.CreateKeyspaceCqlGenerator;
import org.springframework.cassandra.core.cql.generator.DropKeyspaceCqlGenerator;
import org.springframework.cassandra.core.keyspace.CreateKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.DropKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.KeyspaceActionSpecification;
import org.springframework.cassandra.core.util.CollectionUtils;
import org.springframework.cassandra.support.CassandraExceptionTranslator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CassandraCqlClusterFactoryBean
implements FactoryBean<Cluster>,
InitializingBean,
DisposableBean,
BeanNameAware,
PersistenceExceptionTranslator {
    public static final boolean DEFAULT_JMX_REPORTING_ENABLED = true;
    public static final boolean DEFAULT_METRICS_ENABLED = true;
    public static final boolean DEFAULT_SSL_ENABLED = false;
    public static final int DEFAULT_MAX_SCHEMA_AGREEMENT_WAIT_SECONDS = 10;
    public static final int DEFAULT_PORT = 9042;
    public static final String DEFAULT_CONTACT_POINTS = "localhost";
    protected static final Logger log = LoggerFactory.getLogger(CassandraCqlClusterFactoryBean.class);
    private boolean jmxReportingEnabled = true;
    private boolean metricsEnabled = true;
    private boolean sslEnabled = false;
    private int maxSchemaAgreementWaitSeconds = 10;
    private int port = 9042;
    private final PersistenceExceptionTranslator exceptionTranslator = new CassandraExceptionTranslator();
    private Cluster cluster;
    private ClusterBuilderConfigurer clusterBuilderConfigurer;
    private AddressTranslator addressTranslator;
    private AuthProvider authProvider;
    private CompressionType compressionType;
    private Host.StateListener hostStateListener;
    private LatencyTracker latencyTracker;
    private List<CreateKeyspaceSpecification> keyspaceCreations = new ArrayList<CreateKeyspaceSpecification>();
    private List<DropKeyspaceSpecification> keyspaceDrops = new ArrayList<DropKeyspaceSpecification>();
    private Set<KeyspaceActionSpecification<?>> keyspaceSpecifications = new HashSet();
    private List<String> startupScripts = new ArrayList<String>();
    private List<String> shutdownScripts = new ArrayList<String>();
    private LoadBalancingPolicy loadBalancingPolicy;
    private NettyOptions nettyOptions;
    private PoolingOptions poolingOptions;
    private ProtocolVersion protocolVersion;
    private QueryOptions queryOptions;
    private ReconnectionPolicy reconnectionPolicy;
    private RetryPolicy retryPolicy;
    private SpeculativeExecutionPolicy speculativeExecutionPolicy;
    private SocketOptions socketOptions;
    private SSLOptions sslOptions;
    private TimestampGenerator timestampGenerator;
    private String beanName;
    private String clusterName;
    private String contactPoints = "localhost";
    private String password;
    private String username;

    public void afterPropertiesSet() throws Exception {
        String clusterName;
        Assert.isTrue((boolean)StringUtils.hasText((String)this.contactPoints), (String)"At least one server is required");
        Cluster.Builder clusterBuilder = this.newClusterBuilder();
        clusterBuilder.addContactPoints(StringUtils.commaDelimitedListToStringArray((String)this.contactPoints)).withPort(this.port);
        if (this.compressionType != null) {
            clusterBuilder.withCompression(CassandraCqlClusterFactoryBean.convertCompressionType(this.compressionType));
        }
        if (this.poolingOptions != null) {
            clusterBuilder.withPoolingOptions(this.poolingOptions);
        }
        if (this.socketOptions != null) {
            clusterBuilder.withSocketOptions(this.socketOptions);
        }
        if (this.queryOptions != null) {
            clusterBuilder.withQueryOptions(this.queryOptions);
        }
        if (this.authProvider != null) {
            clusterBuilder.withAuthProvider(this.authProvider);
        } else if (this.username != null) {
            clusterBuilder.withCredentials(this.username, this.password);
        }
        if (this.nettyOptions != null) {
            clusterBuilder.withNettyOptions(this.nettyOptions);
        }
        if (this.loadBalancingPolicy != null) {
            clusterBuilder.withLoadBalancingPolicy(this.loadBalancingPolicy);
        }
        if (this.reconnectionPolicy != null) {
            clusterBuilder.withReconnectionPolicy(this.reconnectionPolicy);
        }
        if (this.retryPolicy != null) {
            clusterBuilder.withRetryPolicy(this.retryPolicy);
        }
        if (!this.metricsEnabled) {
            clusterBuilder.withoutMetrics();
        }
        if (!this.jmxReportingEnabled) {
            clusterBuilder.withoutJMXReporting();
        }
        if (this.sslEnabled) {
            if (this.sslOptions == null) {
                clusterBuilder.withSSL();
            } else {
                clusterBuilder.withSSL(this.sslOptions);
            }
        }
        if (this.protocolVersion != null) {
            clusterBuilder.withProtocolVersion(this.protocolVersion);
        }
        if (this.addressTranslator != null) {
            clusterBuilder.withAddressTranslator(this.addressTranslator);
        }
        if (StringUtils.hasText((String)(clusterName = this.resolveClusterName()))) {
            clusterBuilder.withClusterName(clusterName);
        }
        clusterBuilder.withMaxSchemaAgreementWaitSeconds(this.maxSchemaAgreementWaitSeconds);
        if (this.speculativeExecutionPolicy != null) {
            clusterBuilder.withSpeculativeExecutionPolicy(this.speculativeExecutionPolicy);
        }
        if (this.timestampGenerator != null) {
            clusterBuilder.withTimestampGenerator(this.timestampGenerator);
        }
        if (this.clusterBuilderConfigurer != null) {
            this.clusterBuilderConfigurer.configure(clusterBuilder);
        }
        this.cluster = clusterBuilder.build();
        if (this.hostStateListener != null) {
            this.cluster.register(this.hostStateListener);
        }
        if (this.latencyTracker != null) {
            this.cluster.register(this.latencyTracker);
        }
        this.generateSpecificationsFromFactoryBeans();
        this.executeSpecsAndScripts(this.keyspaceCreations, this.startupScripts);
    }

    Cluster.Builder newClusterBuilder() {
        return Cluster.builder();
    }

    private String resolveClusterName() {
        return StringUtils.hasText((String)this.clusterName) ? this.clusterName : this.beanName;
    }

    public void destroy() throws Exception {
        this.executeSpecsAndScripts(this.keyspaceDrops, this.shutdownScripts);
        this.cluster.close();
    }

    public Cluster getObject() {
        return this.cluster;
    }

    public Class<? extends Cluster> getObjectType() {
        return this.cluster != null ? this.cluster.getClass() : Cluster.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    private void generateSpecificationsFromFactoryBeans() {
        for (KeyspaceActionSpecification<?> keyspaceSpecification : this.keyspaceSpecifications) {
            if (keyspaceSpecification instanceof CreateKeyspaceSpecification) {
                this.keyspaceCreations.add((CreateKeyspaceSpecification)keyspaceSpecification);
            }
            if (!(keyspaceSpecification instanceof DropKeyspaceSpecification)) continue;
            this.keyspaceDrops.add((DropKeyspaceSpecification)keyspaceSpecification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSpecsAndScripts(List<? extends KeyspaceActionSpecification<?>> kepspaceActionSpecifications, List<String> scripts) {
        if (!CollectionUtils.isEmpty(kepspaceActionSpecifications) || !CollectionUtils.isEmpty(scripts)) {
            Session session = this.cluster.connect();
            try {
                CqlTemplate template = new CqlTemplate(session);
                for (KeyspaceActionSpecification<?> keyspaceActionSpecification : kepspaceActionSpecifications) {
                    template.execute(this.toCql(keyspaceActionSpecification));
                }
                for (String script : scripts) {
                    template.execute(script);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    private String toCql(KeyspaceActionSpecification<?> keyspaceActionSpecification) {
        return keyspaceActionSpecification instanceof CreateKeyspaceSpecification ? new CreateKeyspaceCqlGenerator((CreateKeyspaceSpecification)keyspaceActionSpecification).toCql() : new DropKeyspaceCqlGenerator((DropKeyspaceSpecification)keyspaceActionSpecification).toCql();
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setContactPoints(String contactPoints) {
        this.contactPoints = contactPoints;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public void setPoolingOptions(PoolingOptions poolingOptions) {
        this.poolingOptions = poolingOptions;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setSocketOptions(SocketOptions socketOptions) {
        this.socketOptions = socketOptions;
    }

    public void setQueryOptions(QueryOptions queryOptions) {
        this.queryOptions = queryOptions;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    public void setNettyOptions(NettyOptions nettyOptions) {
        this.nettyOptions = nettyOptions;
    }

    public void setLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
    }

    public void setReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
        this.reconnectionPolicy = reconnectionPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public void setKeyspaceCreations(List<CreateKeyspaceSpecification> specifications) {
        this.keyspaceCreations = specifications;
    }

    public List<CreateKeyspaceSpecification> getKeyspaceCreations() {
        return this.keyspaceCreations;
    }

    public void setKeyspaceDrops(List<DropKeyspaceSpecification> specifications) {
        this.keyspaceDrops = specifications;
    }

    public List<DropKeyspaceSpecification> getKeyspaceDrops() {
        return this.keyspaceDrops;
    }

    public void setStartupScripts(List<String> scripts) {
        this.startupScripts = scripts;
    }

    public List<String> getStartupScripts() {
        return this.startupScripts;
    }

    public void setShutdownScripts(List<String> scripts) {
        this.shutdownScripts = scripts;
    }

    public List<String> getShutdownScripts() {
        return this.shutdownScripts;
    }

    public void setKeyspaceSpecifications(Set<KeyspaceActionSpecification<?>> keyspaceSpecifications) {
        this.keyspaceSpecifications = keyspaceSpecifications;
    }

    public Set<KeyspaceActionSpecification<?>> getKeyspaceSpecifications() {
        return this.keyspaceSpecifications;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJmxReportingEnabled(boolean jmxReportingEnabled) {
        this.jmxReportingEnabled = jmxReportingEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void setSslOptions(SSLOptions sslOptions) {
        this.sslOptions = sslOptions;
    }

    public void setHostStateListener(Host.StateListener hostStateListener) {
        this.hostStateListener = hostStateListener;
    }

    public void setLatencyTracker(LatencyTracker latencyTracker) {
        this.latencyTracker = latencyTracker;
    }

    public void setAddressTranslator(AddressTranslator addressTranslator) {
        this.addressTranslator = addressTranslator;
    }

    public void setClusterBuilderConfigurer(ClusterBuilderConfigurer clusterBuilderConfigurer) {
        this.clusterBuilderConfigurer = clusterBuilderConfigurer;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setMaxSchemaAgreementWaitSeconds(int seconds) {
        this.maxSchemaAgreementWaitSeconds = seconds;
    }

    public void setSpeculativeExecutionPolicy(SpeculativeExecutionPolicy speculativeExecutionPolicy) {
        this.speculativeExecutionPolicy = speculativeExecutionPolicy;
    }

    public void setTimestampGenerator(TimestampGenerator timestampGenerator) {
        this.timestampGenerator = timestampGenerator;
    }

    private static ProtocolOptions.Compression convertCompressionType(CompressionType type) {
        switch (type) {
            case NONE: {
                return ProtocolOptions.Compression.NONE;
            }
            case SNAPPY: {
                return ProtocolOptions.Compression.SNAPPY;
            }
            case LZ4: {
                return ProtocolOptions.Compression.LZ4;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown compression type [%s]", new Object[]{type}));
    }
}

