/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.cql.generator;

import java.util.Map;
import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.cassandra.core.cql.generator.KeyspaceNameCqlGenerator;
import org.springframework.cassandra.core.keyspace.KeyspaceOptionsSpecification;
import org.springframework.cassandra.core.keyspace.Option;

public abstract class KeyspaceOptionsCqlGenerator<T extends KeyspaceOptionsSpecification<T>>
extends KeyspaceNameCqlGenerator<KeyspaceOptionsSpecification<T>> {
    public KeyspaceOptionsCqlGenerator(KeyspaceOptionsSpecification<T> specification) {
        super(specification);
    }

    @Override
    protected T spec() {
        return (T)((KeyspaceOptionsSpecification)this.getSpecification());
    }

    protected StringBuilder optionValueMap(Map<Option, Object> valueMap, StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        if (valueMap == null || valueMap.isEmpty()) {
            return cql;
        }
        cql.append("{ ");
        boolean mapFirst = true;
        for (Map.Entry<Option, Object> entry : valueMap.entrySet()) {
            if (mapFirst) {
                mapFirst = false;
            } else {
                cql.append(", ");
            }
            Option option = entry.getKey();
            cql.append(CqlStringUtils.singleQuote(option.getName()));
            cql.append(" : ");
            Object entryValue = entry.getValue();
            Object object = entryValue = entryValue == null ? "" : entryValue.toString();
            if (option.escapesValue()) {
                entryValue = CqlStringUtils.escapeSingle(entryValue);
            }
            if (option.quotesValue()) {
                entryValue = CqlStringUtils.singleQuote(entryValue);
            }
            cql.append(entryValue);
        }
        cql.append(" }");
        return cql;
    }
}

