/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.cassandra.convert.AbstractCassandraConverter;
import org.springframework.data.cassandra.convert.BasicCassandraRowValueProvider;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.CassandraPersistentEntityParameterValueProvider;
import org.springframework.data.cassandra.convert.RowReaderPropertyAccessor;
import org.springframework.data.cassandra.mapping.BasicCassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.MapId;
import org.springframework.data.cassandra.repository.MapIdentifiable;
import org.springframework.data.cassandra.repository.support.BasicMapId;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MappingCassandraConverter
extends AbstractCassandraConverter
implements CassandraConverter,
ApplicationContextAware,
BeanClassLoaderAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final CassandraMappingContext mappingContext;
    protected ApplicationContext applicationContext;
    protected SpELContext spELContext;
    protected ClassLoader beanClassLoader;

    public MappingCassandraConverter() {
        this(new BasicCassandraMappingContext());
    }

    public MappingCassandraConverter(CassandraMappingContext mappingContext) {
        super((ConversionService)new DefaultConversionService());
        Assert.notNull((Object)mappingContext);
        this.mappingContext = mappingContext;
        this.spELContext = new SpELContext((PropertyAccessor)RowReaderPropertyAccessor.INSTANCE);
    }

    public <R> R readRow(Class<R> clazz, Row row) {
        Class<R> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(clazz);
        ClassTypeInformation type = ClassTypeInformation.from(beanClassLoaderClass);
        ClassTypeInformation typeToUse = type;
        Class rawType = typeToUse.getType();
        if (Row.class.isAssignableFrom(rawType)) {
            return (R)row;
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity((TypeInformation)typeToUse);
        if (persistentEntity == null) {
            throw new MappingException("No mapping metadata found for " + rawType.getName());
        }
        return (R)this.readEntityFromRow(persistentEntity, row);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    protected <S> S readEntityFromRow(CassandraPersistentEntity<S> entity, Row row) {
        DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)row, this.spELContext);
        BasicCassandraRowValueProvider rowValueProvider = new BasicCassandraRowValueProvider(row, evaluator);
        CassandraPersistentEntityParameterValueProvider parameterProvider = new CassandraPersistentEntityParameterValueProvider((PersistentEntity<?, CassandraPersistentProperty>)entity, rowValueProvider, null);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)parameterProvider);
        BeanWrapper wrapper = BeanWrapper.create((Object)instance, (ConversionService)this.conversionService);
        this.readPropertiesFromRow(entity, rowValueProvider, wrapper);
        return (S)wrapper.getBean();
    }

    protected void readPropertiesFromRow(final CassandraPersistentEntity<?> entity, final BasicCassandraRowValueProvider row, final BeanWrapper<?> wrapper) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty prop) {
                MappingCassandraConverter.this.readPropertyFromRow(entity, prop, row, wrapper);
            }
        });
    }

    protected void readPropertyFromRow(CassandraPersistentEntity<?> entity, CassandraPersistentProperty prop, BasicCassandraRowValueProvider row, BeanWrapper<?> wrapper) {
        if (entity.isConstructorArgument(prop)) {
            return;
        }
        if (prop.isCompositePrimaryKey()) {
            CassandraPersistentProperty keyProperty = (CassandraPersistentProperty)entity.getIdProperty();
            Object key = wrapper.getProperty((PersistentProperty)keyProperty);
            if (key == null) {
                key = this.instantiatePrimaryKey(keyProperty.getCompositePrimaryKeyEntity(), keyProperty, row);
            }
            BeanWrapper keyWrapper = BeanWrapper.create((Object)key, (ConversionService)this.conversionService);
            this.readPropertiesFromRow(prop.getCompositePrimaryKeyEntity(), row, keyWrapper);
            wrapper.setProperty((PersistentProperty)keyProperty, keyWrapper.getBean());
            return;
        }
        if (!row.getRow().getColumnDefinitions().contains(prop.getColumnName().toCql())) {
            return;
        }
        Object obj = row.getPropertyValue(prop);
        wrapper.setProperty((PersistentProperty)prop, obj);
    }

    protected Object instantiatePrimaryKey(CassandraPersistentEntity<?> entity, CassandraPersistentProperty keyProperty, BasicCassandraRowValueProvider propertyProvider) {
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        return instantiator.createInstance(entity, (ParameterValueProvider)new CassandraPersistentEntityParameterValueProvider((PersistentEntity<?, CassandraPersistentProperty>)entity, propertyProvider, null));
    }

    public <R> R read(Class<R> type, Object row) {
        if (row instanceof Row) {
            return this.readRow(type, (Row)row);
        }
        throw new MappingException("Unknown row object " + row.getClass().getName());
    }

    public void write(Object source, Object sink) {
        if (source == null) {
            return;
        }
        Class<?> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(source.getClass());
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(beanClassLoaderClass);
        if (entity == null) {
            throw new MappingException("No mapping metadata found for " + source.getClass());
        }
        if (sink instanceof Insert) {
            this.writeInsertFromObject(source, (Insert)sink, entity);
        } else if (sink instanceof Update) {
            this.writeUpdateFromObject(source, (Update)sink, entity);
        } else if (sink instanceof Delete.Where) {
            this.writeDeleteWhereFromObject(source, (Delete.Where)sink, entity);
        } else {
            throw new MappingException("Unknown buildStatement " + sink.getClass().getName());
        }
    }

    protected void writeInsertFromObject(Object object, Insert insert, CassandraPersistentEntity<?> entity) {
        this.writeInsertFromWrapper((BeanWrapper<Object>)BeanWrapper.create((Object)object, (ConversionService)this.conversionService), insert, entity);
    }

    protected void writeInsertFromWrapper(final BeanWrapper<Object> wrapper, final Insert insert, CassandraPersistentEntity<?> entity) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty prop) {
                Object value = wrapper.getProperty((PersistentProperty)prop, prop.getType());
                MappingCassandraConverter.this.log.debug("prop.type -> " + prop.getType().getName());
                MappingCassandraConverter.this.log.debug("prop.value -> " + value);
                if (prop.isCompositePrimaryKey()) {
                    MappingCassandraConverter.this.log.debug("prop is a compositeKey");
                    MappingCassandraConverter.this.writeInsertFromWrapper((BeanWrapper<Object>)BeanWrapper.create((Object)value, (ConversionService)MappingCassandraConverter.this.conversionService), insert, prop.getCompositePrimaryKeyEntity());
                    return;
                }
                if (value != null) {
                    MappingCassandraConverter.this.log.debug(String.format("Adding insert.value [%s] - [%s]", prop.getColumnName().toCql(), value));
                    insert.value(prop.getColumnName().toCql(), value);
                }
            }
        });
    }

    protected void writeUpdateFromObject(Object object, Update update, CassandraPersistentEntity<?> entity) {
        this.writeUpdateFromWrapper((BeanWrapper<Object>)BeanWrapper.create((Object)object, (ConversionService)this.conversionService), update, entity);
    }

    protected void writeUpdateFromWrapper(final BeanWrapper<Object> wrapper, final Update update, final CassandraPersistentEntity<?> entity) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty prop) {
                Object value = wrapper.getProperty((PersistentProperty)prop, prop.getType());
                if (prop.isCompositePrimaryKey()) {
                    MappingCassandraConverter.this.writeUpdateFromWrapper((BeanWrapper<Object>)BeanWrapper.create((Object)value, (ConversionService)MappingCassandraConverter.this.conversionService), update, prop.getCompositePrimaryKeyEntity());
                    return;
                }
                if (value != null) {
                    if (prop.isIdProperty() || entity.isCompositePrimaryKey() || prop.isPrimaryKeyColumn()) {
                        update.where(QueryBuilder.eq((String)prop.getColumnName().toCql(), (Object)value));
                    } else {
                        update.with(QueryBuilder.set((String)prop.getColumnName().toCql(), (Object)value));
                    }
                }
            }
        });
    }

    protected void writeDeleteWhereFromObject(Object object, Delete.Where where, CassandraPersistentEntity<?> entity) {
        this.writeDeleteWhereFromWrapper((BeanWrapper<Object>)BeanWrapper.create((Object)object, (ConversionService)this.conversionService), where, entity);
    }

    protected void writeDeleteWhereFromWrapper(BeanWrapper<Object> wrapper, Delete.Where where, CassandraPersistentEntity<?> entity) {
        Object id = this.getId(wrapper, entity);
        if (id == null) {
            String msg = String.format("no id value found in object {}", wrapper.getBean());
            this.log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (id instanceof MapId) {
            for (Map.Entry entry : ((MapId)id).entrySet()) {
                where.and(QueryBuilder.eq((String)((String)entry.getKey()), entry.getValue()));
            }
            return;
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            if (idProperty.isCompositePrimaryKey()) {
                this.writeDeleteWhereFromWrapper((BeanWrapper<Object>)BeanWrapper.create((Object)id, (ConversionService)this.conversionService), where, idProperty.getCompositePrimaryKeyEntity());
                return;
            }
            where.and(QueryBuilder.eq((String)idProperty.getColumnName().toCql(), (Object)id));
            return;
        }
    }

    @Override
    public Object getId(Object object, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)object);
        final BeanWrapper wrapper = object instanceof BeanWrapper ? (BeanWrapper)object : BeanWrapper.create((Object)object, (ConversionService)this.conversionService);
        Object object2 = object = wrapper == null ? object : wrapper.getBean();
        if (!entity.getType().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException(String.format("given instance of type [%s] is not of compatible expected type [%s]", object.getClass().getName(), entity.getType().getName()));
        }
        if (object instanceof MapIdentifiable) {
            return ((MapIdentifiable)object).getMapId();
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            return wrapper.getProperty(entity.getIdProperty(), idProperty.getType());
        }
        final MapId id = BasicMapId.id();
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty p) {
                if (p.isPrimaryKeyColumn()) {
                    id.with(p.getName(), (Serializable)wrapper.getProperty((PersistentProperty)p, p.getType()));
                }
            }
        });
        return id;
    }

    protected <T> Class<T> transformClassToBeanClassLoaderClass(Class<T> entity) {
        try {
            return ClassUtils.forName((String)entity.getName(), (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException e) {
            return entity;
        }
        catch (LinkageError e) {
            return entity;
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }
}

