/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.mapping.Table;
import org.springframework.data.cassandra.mapping.VerifierMappingExceptions;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.MappingException;

public class BasicCassandraPersistentEntityMetadataVerifier
implements CassandraPersistentEntityMetadataVerifier {
    private static final Logger log = LoggerFactory.getLogger(BasicCassandraPersistentEntityMetadataVerifier.class);
    protected boolean strict = false;

    @Override
    public void verify(CassandraPersistentEntity<?> entity) throws MappingException {
        VerifierMappingExceptions exceptions = new VerifierMappingExceptions(entity, "Mapping Exceptions from BasicCassandraPersistentEntityMetadataVerifier");
        final ArrayList idProperties = new ArrayList();
        final ArrayList compositePrimaryKeys = new ArrayList();
        final ArrayList partitionKeyColumns = new ArrayList();
        final ArrayList clusterKeyColumns = new ArrayList();
        final ArrayList primaryKeyColumns = new ArrayList();
        Class thisType = entity.getType();
        boolean isTable = thisType.isAnnotationPresent(Table.class) || thisType.isAnnotationPresent(Persistent.class);
        boolean isPrimaryKeyClass = thisType.isAnnotationPresent(PrimaryKeyClass.class);
        if (isTable && isPrimaryKeyClass) {
            exceptions.add(new MappingException("Entity cannot be of type Table and PrimaryKey"));
            throw exceptions;
        }
        if (!isTable && !isPrimaryKeyClass) {
            exceptions.add(new MappingException("Cassandra entities must have the @Table, @Persistent or @PrimaryKeyClass Annotation"));
            throw exceptions;
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty p) {
                if (p.isIdProperty()) {
                    idProperties.add(p);
                } else if (p.isCompositePrimaryKey()) {
                    compositePrimaryKeys.add(p);
                } else if (p.isPartitionKeyColumn()) {
                    partitionKeyColumns.add(p);
                    primaryKeyColumns.add(p);
                } else if (p.isClusterKeyColumn()) {
                    clusterKeyColumns.add(p);
                    primaryKeyColumns.add(p);
                }
            }
        });
        int idPropertyCount = idProperties.size();
        int partitionKeyColumnCount = partitionKeyColumns.size();
        int primaryKeyColumnCount = primaryKeyColumns.size();
        if (isPrimaryKeyClass) {
            String message;
            if (primaryKeyColumnCount == 0) {
                exceptions.add(new MappingException(String.format("composite primary key type [%s] has no fields annotated with @%s", entity.getType().getName(), PrimaryKeyColumn.class.getSimpleName())));
            }
            if (partitionKeyColumnCount == 0) {
                exceptions.add(new MappingException("At least one of the @PrimaryKeyColumn annotation must have a type of PARTITIONED"));
            }
            if (idPropertyCount > 0) {
                exceptions.add(new MappingException("Annotations @Id and @PrimaryKey are invalid for type annotated with @PrimaryKeyClass"));
            }
            for (CassandraPersistentProperty p : primaryKeyColumns) {
                if (CassandraSimpleTypeHolder.getDataTypeFor(p.getType()) != null) continue;
                exceptions.add(new MappingException("Fields annotated with @PrimaryKeyColumn must be simple CassandraTypes"));
            }
            if (!Serializable.class.isAssignableFrom(thisType)) {
                exceptions.add(new MappingException("@PrimaryKeyClass must be Serializable"));
            }
            if (!thisType.getSuperclass().equals(Object.class)) {
                exceptions.add(new MappingException("@PrimaryKeyClass must only extend Object"));
            }
            try {
                Method equalsMethod = thisType.getDeclaredMethod("equals", Object.class);
                if (equalsMethod == null || !equalsMethod.getDeclaringClass().equals(thisType)) {
                    throw new NoSuchMethodException();
                }
            }
            catch (NoSuchMethodException e) {
                message = "@PrimaryKeyClass should override 'boolean equals(Object)' method and use all @PrimaryKeyColumn fields";
                if (this.strict) {
                    exceptions.add(new MappingException(message, (Throwable)e));
                }
                log.warn(message);
            }
            try {
                Method hashCodeMethod = thisType.getDeclaredMethod("hashCode", null);
                if (hashCodeMethod == null || !hashCodeMethod.getDeclaringClass().equals(thisType)) {
                    throw new NoSuchMethodException();
                }
            }
            catch (NoSuchMethodException e) {
                message = "@PrimaryKeyClass should override 'int hashCode()' method and use all @PrimaryKeyColumn fields";
                if (this.strict) {
                    exceptions.add(new MappingException(message, (Throwable)e));
                }
                log.warn(message);
            }
        }
        if (isTable) {
            if (primaryKeyColumnCount == 0) {
                if (idPropertyCount != 1) {
                    exceptions.add(new MappingException(String.format("@Table/@Persistent types must have only one @PrimaryKey attribute, if any.  Found %s.", idPropertyCount)));
                    throw exceptions;
                }
                Class typeClass = ((CassandraPersistentProperty)idProperties.get(0)).getType();
                if (!typeClass.isAnnotationPresent(PrimaryKeyClass.class) && CassandraSimpleTypeHolder.getDataTypeFor(typeClass) == null) {
                    exceptions.add(new MappingException("Fields annotated with @PrimaryKey must be simple CassandraTypes or @PrimaryKeyClass type"));
                }
            } else {
                if (idPropertyCount > 0) {
                    exceptions.add(new MappingException(String.format("@Table/@Persistent types must not define both @PrimaryKeyColumn field%s (found %s) and @PrimaryKey field%s (found %s)", primaryKeyColumnCount == 1 ? "" : "s", primaryKeyColumnCount, idPropertyCount == 1 ? "" : "s", idPropertyCount)));
                    throw exceptions;
                }
                if (partitionKeyColumnCount == 0) {
                    exceptions.add(new MappingException(String.format("@Table/@Persistent types must define at least one @PrimaryKeyColumn of type PARTITIONED", new Object[0])));
                }
            }
        }
        if (exceptions.getCount() > 0) {
            log.error("Exceptions while verifying PersistentEntity", (Throwable)((Object)exceptions));
            throw exceptions;
        }
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

