/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cassandra.core.SessionCallback;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.cql.generator.CreateTableCqlGenerator;
import org.springframework.cassandra.core.cql.generator.DropUserTypeCqlGenerator;
import org.springframework.cassandra.core.keyspace.DropTableSpecification;
import org.springframework.cassandra.core.keyspace.DropUserTypeSpecification;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.util.CqlUtils;
import org.springframework.util.Assert;

public class CassandraAdminTemplate
extends CassandraTemplate
implements CassandraAdminOperations {
    private static final Logger log = LoggerFactory.getLogger(CassandraAdminTemplate.class);

    public CassandraAdminTemplate(Session session, CassandraConverter converter) {
        super(session, converter);
    }

    @Override
    public void createTable(final boolean ifNotExists, CqlIdentifier tableName, Class<?> entityClass, Map<String, Object> optionsByName) {
        final CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getCassandraMappingContext().getPersistentEntity(entityClass);
        this.execute((SessionCallback)new SessionCallback<Object>(){

            public Object doInSession(Session s) throws DataAccessException {
                String cql = new CreateTableCqlGenerator(CassandraAdminTemplate.this.getCassandraMappingContext().getCreateTableSpecificationFor(entity).ifNotExists(ifNotExists)).toCql();
                log.debug(cql);
                s.execute(cql);
                return null;
            }
        });
    }

    @Override
    public void alterTable(CqlIdentifier tableName, Class<?> entityClass, boolean dropRemovedAttributeColumns) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void replaceTable(CqlIdentifier tableName, Class<?> entityClass, Map<String, Object> optionsByName) {
        this.dropTable(tableName);
        this.createTable(false, tableName, entityClass, optionsByName);
    }

    protected void doAlterTable(Class<?> entityClass, String keyspace, CqlIdentifier tableName) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getCassandraMappingContext().getPersistentEntity(entityClass);
        Assert.notNull((Object)entity, (String)"Entity must not be null!");
        TableMetadata tableMetadata = this.getTableMetadata(keyspace, tableName);
        final List<String> queryList = CqlUtils.alterTable(tableName.toCql(), entity, tableMetadata);
        this.execute((SessionCallback)new SessionCallback<Object>(){

            public Object doInSession(Session s) throws DataAccessException {
                for (String q : queryList) {
                    log.info(q);
                    s.execute(q);
                }
                return null;
            }
        });
    }

    public void dropTable(Class<?> entityClass) {
        this.dropTable(this.getTableName(entityClass));
    }

    @Override
    public void dropTable(CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        log.info("Dropping table => " + tableName);
        this.execute(DropTableSpecification.dropTable((CqlIdentifier)tableName));
    }

    @Override
    public void dropUserType(CqlIdentifier typeName) {
        Assert.notNull((Object)typeName, (String)"Type name must not be null");
        log.info("Dropping user type => {}", (Object)typeName);
        this.execute(DropUserTypeCqlGenerator.toCql((DropUserTypeSpecification)DropUserTypeSpecification.dropType((CqlIdentifier)typeName)));
    }

    @Override
    public TableMetadata getTableMetadata(final String keyspace, final CqlIdentifier tableName) {
        Assert.hasText((String)keyspace, (String)"Keyspace name must not be empty");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        return (TableMetadata)this.execute((SessionCallback)new SessionCallback<TableMetadata>(){

            public TableMetadata doInSession(Session s) {
                return s.getCluster().getMetadata().getKeyspace(keyspace).getTable(tableName.toCql());
            }
        });
    }

    @Override
    public KeyspaceMetadata getKeyspaceMetadata() {
        return (KeyspaceMetadata)this.execute((SessionCallback)new SessionCallback<KeyspaceMetadata>(){

            public KeyspaceMetadata doInSession(Session s) throws DataAccessException {
                KeyspaceMetadata keyspaceMetadata = s.getCluster().getMetadata().getKeyspace(s.getLoggedKeyspace());
                Assert.state((keyspaceMetadata != null ? 1 : 0) != 0, (String)String.format("Metadata for keyspace [%s] not available", s.getLoggedKeyspace()));
                return keyspaceMetadata;
            }
        });
    }
}

