/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.MapId;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.util.Assert;

public class MappingCassandraEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID>
implements CassandraEntityInformation<T, ID> {
    private final CassandraPersistentEntity<T> entityMetadata;
    private final CassandraConverter converter;
    private final boolean isPrimaryKeyEntity;

    public MappingCassandraEntityInformation(CassandraPersistentEntity<T> entity, CassandraConverter converter) {
        super(entity.getType());
        this.entityMetadata = entity;
        this.converter = converter;
        this.isPrimaryKeyEntity = MappingCassandraEntityInformation.hasNonIdProperties(entity);
    }

    public ID getId(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)this.entityMetadata.getIdProperty();
        if (idProperty != null) {
            return (ID)((Serializable)this.entityMetadata.getIdentifierAccessor(entity).getIdentifier());
        }
        return (ID)((Serializable)this.converter.getId(entity, this.entityMetadata));
    }

    public Class<ID> getIdType() {
        return this.entityMetadata.getIdProperty() == null ? MapId.class : ((CassandraPersistentProperty)this.entityMetadata.getIdProperty()).getType();
    }

    @Override
    public CqlIdentifier getTableName() {
        return this.entityMetadata.getTableName();
    }

    @Override
    public boolean isPrimaryKeyEntity() {
        return this.isPrimaryKeyEntity;
    }

    private static boolean hasNonIdProperties(CassandraPersistentEntity<?> entity) {
        final AtomicReference<Boolean> hasPrimaryKeyOnlyProperties = new AtomicReference<Boolean>(true);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                if (property.isCompositePrimaryKey() || property.isPrimaryKeyColumn() || property.isIdProperty()) {
                    return;
                }
                hasPrimaryKeyOnlyProperties.set(false);
            }
        });
        return hasPrimaryKeyOnlyProperties.get();
    }
}

