/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.AbstractTableMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class CassandraPersistentEntitySchemaDropper {
    private final CassandraAdminOperations cassandraAdminOperations;
    private final CassandraMappingContext mappingContext;

    public CassandraPersistentEntitySchemaDropper(CassandraMappingContext mappingContext, CassandraAdminOperations cassandraAdminOperations) {
        Assert.notNull((Object)cassandraAdminOperations, (String)"CassandraAdminOperations must not be null");
        Assert.notNull((Object)((Object)mappingContext), (String)"CassandraMappingContext must not be null");
        this.cassandraAdminOperations = cassandraAdminOperations;
        this.mappingContext = mappingContext;
    }

    public void dropTables(boolean dropUnused) {
        this.cassandraAdminOperations.getKeyspaceMetadata().getTables().stream().map(AbstractTableMetadata::getName).map(CqlIdentifier::of).filter(table -> dropUnused || this.mappingContext.usesTable((CqlIdentifier)table)).forEach(this.cassandraAdminOperations::dropTable);
    }

    public void dropUserTypes(boolean dropUnused) {
        Set canRecreate = this.mappingContext.getUserDefinedTypeEntities().stream().map(CassandraPersistentEntity::getTableName).collect(Collectors.toSet());
        Collection userTypes = this.cassandraAdminOperations.getKeyspaceMetadata().getUserTypes();
        this.getUserTypesToDrop(userTypes).stream().filter(it -> canRecreate.contains(it) || dropUnused && !this.mappingContext.usesUserType((CqlIdentifier)it)).forEach(this.cassandraAdminOperations::dropUserType);
    }

    private List<CqlIdentifier> getUserTypesToDrop(Collection<UserType> knownUserTypes) {
        ArrayList<CqlIdentifier> toDrop = new ArrayList<CqlIdentifier>();
        UserTypeDependencyGraphBuilder builder = new UserTypeDependencyGraphBuilder();
        knownUserTypes.forEach(builder::addUserType);
        UserTypeDependencyGraph dependencyGraph = builder.build();
        LinkedHashSet globalSeen = new LinkedHashSet();
        knownUserTypes.forEach(userType -> {
            CqlIdentifier typeName = CqlIdentifier.of(userType.getTypeName());
            toDrop.addAll(dependencyGraph.getDropOrder(typeName, globalSeen::add));
        });
        return toDrop;
    }

    static class UserTypeDependencyGraph {
        private final MultiValueMap<CqlIdentifier, CqlIdentifier> dependencies;

        UserTypeDependencyGraph(MultiValueMap<CqlIdentifier, CqlIdentifier> dependencies) {
            this.dependencies = dependencies;
        }

        List<CqlIdentifier> getDropOrder(CqlIdentifier typeName, Predicate<CqlIdentifier> typeFilter) {
            ArrayList<CqlIdentifier> toDrop = new ArrayList<CqlIdentifier>();
            if (typeFilter.test(typeName)) {
                List dependants = (List)this.dependencies.getOrDefault((Object)typeName, Collections.emptyList());
                dependants.stream().map(dependant -> this.getDropOrder((CqlIdentifier)dependant, typeFilter)).forEach(toDrop::addAll);
                toDrop.add(typeName);
            }
            return toDrop;
        }
    }

    static class UserTypeDependencyGraphBuilder {
        private final MultiValueMap<CqlIdentifier, CqlIdentifier> dependencies = new LinkedMultiValueMap();

        UserTypeDependencyGraphBuilder() {
        }

        void addUserType(UserType userType) {
            LinkedHashSet seen = new LinkedHashSet();
            this.visitTypes(userType, seen::add);
        }

        UserTypeDependencyGraph build() {
            return new UserTypeDependencyGraph((MultiValueMap<CqlIdentifier, CqlIdentifier>)new LinkedMultiValueMap(this.dependencies));
        }

        private void visitTypes(UserType userType, Predicate<CqlIdentifier> typeFilter) {
            CqlIdentifier typeName = CqlIdentifier.of(userType.getTypeName());
            if (!typeFilter.test(typeName)) {
                return;
            }
            for (UserType.Field field : userType) {
                if (field.getType() instanceof UserType) {
                    this.addDependency((UserType)field.getType(), typeName, typeFilter);
                    return;
                }
                UserTypeDependencyGraphBuilder.doWithTypeArguments(field.getType(), it -> {
                    if (it instanceof UserType) {
                        this.addDependency((UserType)it, typeName, typeFilter);
                    }
                });
            }
        }

        private void addDependency(UserType userType, CqlIdentifier requiredBy, Predicate<CqlIdentifier> typeFilter) {
            this.dependencies.add((Object)CqlIdentifier.of(userType.getTypeName()), (Object)requiredBy);
            this.visitTypes(userType, typeFilter);
        }

        private static void doWithTypeArguments(DataType type, Consumer<DataType> callback) {
            type.getTypeArguments().forEach(nested -> {
                callback.accept((DataType)nested);
                UserTypeDependencyGraphBuilder.doWithTypeArguments(nested, callback);
            });
            if (type instanceof TupleType) {
                TupleType tupleType = (TupleType)type;
                tupleType.getComponentTypes().forEach(nested -> {
                    callback.accept((DataType)nested);
                    UserTypeDependencyGraphBuilder.doWithTypeArguments(nested, callback);
                });
            }
        }
    }
}

