/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import lombok.NonNull;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.ReactiveDeleteOperation;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

class ReactiveDeleteOperationSupport
implements ReactiveDeleteOperation {
    @NonNull
    private final ReactiveCassandraTemplate template;

    @Override
    public ReactiveDeleteOperation.ReactiveDelete delete(Class<?> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveDeleteSupport(this.template, domainType, Query.empty(), null);
    }

    public ReactiveDeleteOperationSupport(@NonNull ReactiveCassandraTemplate template) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        this.template = template;
    }

    static class ReactiveDeleteSupport
    implements ReactiveDeleteOperation.ReactiveDelete,
    ReactiveDeleteOperation.TerminatingDelete {
        @NonNull
        private final ReactiveCassandraTemplate template;
        @NonNull
        private final Class<?> domainType;
        @NonNull
        private final Query query;
        @Nullable
        private final CqlIdentifier tableName;

        @Override
        public ReactiveDeleteOperation.DeleteWithQuery inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveDeleteSupport(this.template, this.domainType, this.query, tableName);
        }

        @Override
        public ReactiveDeleteOperation.TerminatingDelete matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ReactiveDeleteSupport(this.template, this.domainType, query2, this.tableName);
        }

        @Override
        public Mono<WriteResult> all() {
            return this.template.doDelete(this.query, this.domainType, this.getTableName());
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }

        public ReactiveDeleteSupport(@NonNull ReactiveCassandraTemplate template, @NonNull Class<?> domainType, @NonNull Query query2, @Nullable CqlIdentifier tableName) {
            if (template == null) {
                throw new NullPointerException("template");
            }
            if (domainType == null) {
                throw new NullPointerException("domainType");
            }
            if (query2 == null) {
                throw new NullPointerException("query");
            }
            this.template = template;
            this.domainType = domainType;
            this.query = query2;
            this.tableName = tableName;
        }
    }
}

