/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class BeanWrapper<T>
implements PersistentPropertyAccessor {
    private final T bean;

    @Deprecated
    public static <T> BeanWrapper<T> create(T bean, ConversionService conversionService) {
        return new BeanWrapper<T>(bean);
    }

    protected BeanWrapper(T bean) {
        Assert.notNull(bean, (String)"Bean must not be null!");
        this.bean = bean;
    }

    @Override
    public void setProperty(PersistentProperty<?> property, Object value) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        Method setter = property.getSetter();
        try {
            if (!property.usePropertyAccess()) {
                ReflectionUtils.makeAccessible((Field)property.getField());
                ReflectionUtils.setField((Field)property.getField(), this.bean, (Object)value);
            } else if (property.usePropertyAccess() && setter != null) {
                ReflectionUtils.makeAccessible((Method)setter);
                ReflectionUtils.invokeMethod((Method)setter, this.bean, (Object[])new Object[]{value});
            }
        }
        catch (IllegalStateException e) {
            throw new MappingException("Could not set object property!", e);
        }
    }

    @Override
    public Object getProperty(PersistentProperty<?> property) {
        return this.getProperty(property, property.getType());
    }

    public <S> S getProperty(PersistentProperty<?> property, Class<? extends S> type) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        try {
            Method getter = property.getGetter();
            if (!property.usePropertyAccess()) {
                Field field = property.getField();
                ReflectionUtils.makeAccessible((Field)field);
                return (S)ReflectionUtils.getField((Field)field, this.bean);
            }
            if (property.usePropertyAccess() && getter != null) {
                ReflectionUtils.makeAccessible((Method)getter);
                return (S)ReflectionUtils.invokeMethod((Method)getter, this.bean);
            }
            return null;
        }
        catch (IllegalStateException e) {
            throw new MappingException(String.format("Could not read property %s of %s!", property.toString(), this.bean.toString()), e);
        }
    }

    public T getBean() {
        return this.bean;
    }
}

