/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.util.TypeInformation;

public interface PersistentProperty<P extends PersistentProperty<P>> {
    public PersistentEntity<?, P> getOwner();

    public String getName();

    public Class<?> getType();

    public TypeInformation<?> getTypeInformation();

    public Iterable<? extends TypeInformation<?>> getPersistentEntityType();

    public Optional<Method> getGetter();

    public Optional<Method> getSetter();

    public Optional<Field> getField();

    public Optional<String> getSpelExpression();

    public Optional<Association<P>> getAssociation();

    default public Association<P> getRequiredAssociation() {
        return this.getAssociation().orElseThrow(() -> new IllegalStateException("No association found!"));
    }

    public boolean isEntity();

    public boolean isIdProperty();

    public boolean isVersionProperty();

    public boolean isCollectionLike();

    public boolean isMap();

    public boolean isArray();

    public boolean isTransient();

    public boolean isWritable();

    public boolean isAssociation();

    public Optional<Class<?>> getComponentType();

    public Class<?> getRawType();

    public Optional<Class<?>> getMapValueType();

    public Class<?> getActualType();

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> var1);

    public <A extends Annotation> Optional<A> findPropertyOrOwnerAnnotation(Class<A> var1);

    public boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public boolean usePropertyAccess();
}

