/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class BeanWrapper<T>
implements PersistentPropertyAccessor {
    private final T bean;

    protected BeanWrapper(T bean) {
        Assert.notNull(bean, (String)"Bean must not be null!");
        this.bean = bean;
    }

    @Override
    public void setProperty(PersistentProperty<?> property, Optional<? extends Object> value) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        try {
            if (!property.usePropertyAccess()) {
                Field field = property.getField().get();
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, this.bean, value.orElse(null));
                return;
            }
            Optional<Method> setter = property.getSetter();
            setter.ifPresent(it -> {
                ReflectionUtils.makeAccessible((Method)it);
                ReflectionUtils.invokeMethod((Method)it, this.bean, (Object[])new Object[]{value.orElse(null)});
            });
        }
        catch (IllegalStateException e) {
            throw new MappingException("Could not set object property!", e);
        }
    }

    @Override
    public Optional<Object> getProperty(PersistentProperty<?> property) {
        return this.getProperty(property, property.getType());
    }

    public <S> Optional<S> getProperty(PersistentProperty<?> property, Class<? extends S> type) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        try {
            if (!property.usePropertyAccess()) {
                Field field = property.getField().get();
                ReflectionUtils.makeAccessible((Field)field);
                return Optional.ofNullable(ReflectionUtils.getField((Field)field, this.bean));
            }
            Optional<Method> getter = property.getGetter();
            return getter.map(it -> {
                ReflectionUtils.makeAccessible((Method)it);
                return ReflectionUtils.invokeMethod((Method)it, this.bean);
            });
        }
        catch (IllegalStateException e) {
            throw new MappingException(String.format("Could not read property %s of %s!", property.toString(), this.bean.toString()), e);
        }
    }

    public T getBean() {
        return this.bean;
    }
}

