/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;

public class DefaultMethodInvokingMethodInterceptor
implements MethodInterceptor {
    private final Constructor<MethodHandles.Lookup> constructor;

    public DefaultMethodInvokingMethodInterceptor() {
        try {
            this.constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            if (!this.constructor.isAccessible()) {
                this.constructor.setAccessible(true);
            }
        }
        catch (Exception o_O) {
            throw new IllegalStateException(o_O);
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!method.isDefault()) {
            return invocation.proceed();
        }
        Object[] arguments = invocation.getArguments();
        Class<?> declaringClass = method.getDeclaringClass();
        Object proxy = ((ProxyMethodInvocation)invocation).getProxy();
        return this.constructor.newInstance(declaringClass).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(arguments);
    }
}

