/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.util.Assert;

public class CustomRepositoryImplementationDetector {
    private static final String CUSTOM_IMPLEMENTATION_RESOURCE_PATTERN = "**/*%s.class";
    @NonNull
    private final MetadataReaderFactory metadataReaderFactory;
    @NonNull
    private final Environment environment;
    @NonNull
    private final ResourceLoader resourceLoader;

    public Optional<AbstractBeanDefinition> detectCustomImplementation(RepositoryConfiguration<?> configuration) {
        return this.detectCustomImplementation(configuration.getImplementationClassName(), configuration.getBasePackages(), configuration.getExcludeFilters());
    }

    public Optional<AbstractBeanDefinition> detectCustomImplementation(String className, Iterable<String> basePackages, Iterable<TypeFilter> excludeFilters) {
        Assert.notNull((Object)className, (String)"ClassName must not be null!");
        Assert.notNull(basePackages, (String)"BasePackages must not be null!");
        Pattern pattern = Pattern.compile(".*\\." + className);
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.setEnvironment(this.environment);
        provider.setResourceLoader(this.resourceLoader);
        provider.setResourcePattern(String.format(CUSTOM_IMPLEMENTATION_RESOURCE_PATTERN, className));
        provider.setMetadataReaderFactory(this.metadataReaderFactory);
        provider.addIncludeFilter((TypeFilter)new RegexPatternTypeFilter(pattern));
        for (TypeFilter excludeFilter : excludeFilters) {
            provider.addExcludeFilter(excludeFilter);
        }
        HashSet definitions = new HashSet();
        for (String basePackage : basePackages) {
            definitions.addAll(provider.findCandidateComponents(basePackage));
        }
        if (definitions.isEmpty()) {
            return Optional.empty();
        }
        if (definitions.size() == 1) {
            return Optional.of((AbstractBeanDefinition)definitions.iterator().next());
        }
        throw new IllegalStateException(String.format("Ambiguous custom implementations detected! Found %s but expected a single implementation!", definitions.stream().map(BeanDefinition::getBeanClassName).collect(Collectors.joining(", "))));
    }

    @ConstructorProperties(value={"metadataReaderFactory", "environment", "resourceLoader"})
    public CustomRepositoryImplementationDetector(@NonNull MetadataReaderFactory metadataReaderFactory, @NonNull Environment environment, @NonNull ResourceLoader resourceLoader) {
        if (metadataReaderFactory == null) {
            throw new IllegalArgumentException("metadataReaderFactory is null");
        }
        if (environment == null) {
            throw new IllegalArgumentException("environment is null");
        }
        if (resourceLoader == null) {
            throw new IllegalArgumentException("resourceLoader is null");
        }
        this.metadataReaderFactory = metadataReaderFactory;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
    }
}

