/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class DefaultCrudMethods
implements CrudMethods {
    private static final String FIND_ONE = "findOne";
    private static final String SAVE = "save";
    private static final String FIND_ALL = "findAll";
    private static final String DELETE = "delete";
    private final Optional<Method> findAllMethod;
    private final Optional<Method> findOneMethod;
    private final Optional<Method> saveMethod;
    private final Optional<Method> deleteMethod;

    public DefaultCrudMethods(RepositoryMetadata metadata) {
        Assert.notNull((Object)metadata, (String)"RepositoryInformation must not be null!");
        this.findOneMethod = this.selectMostSuitableFindOneMethod(metadata);
        this.findAllMethod = this.selectMostSuitableFindAllMethod(metadata);
        this.deleteMethod = this.selectMostSuitableDeleteMethod(metadata);
        this.saveMethod = this.selectMostSuitableSaveMethod(metadata);
    }

    private Optional<Method> selectMostSuitableSaveMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(metadata.getDomainType(), Object.class)) {
            Method saveMethodCandidate = ReflectionUtils.findMethod(metadata.getRepositoryInterface(), (String)SAVE, (Class[])new Class[]{type});
            if (saveMethodCandidate == null) continue;
            return DefaultCrudMethods.getMostSpecificMethod(saveMethodCandidate, metadata.getRepositoryInterface());
        }
        return Optional.empty();
    }

    private Optional<Method> selectMostSuitableDeleteMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(metadata.getDomainType(), metadata.getIdType(), Serializable.class, Iterable.class)) {
            Method candidate = ReflectionUtils.findMethod(metadata.getRepositoryInterface(), (String)DELETE, (Class[])new Class[]{type});
            if (candidate == null) continue;
            return DefaultCrudMethods.getMostSpecificMethod(candidate, metadata.getRepositoryInterface());
        }
        return Optional.empty();
    }

    private Optional<Method> selectMostSuitableFindAllMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(Pageable.class, Sort.class)) {
            Method candidate;
            if (!ClassUtils.hasMethod(metadata.getRepositoryInterface(), (String)FIND_ALL, (Class[])new Class[]{type}) || (candidate = ReflectionUtils.findMethod(PagingAndSortingRepository.class, (String)FIND_ALL, (Class[])new Class[]{type})) == null) continue;
            return DefaultCrudMethods.getMostSpecificMethod(candidate, metadata.getRepositoryInterface());
        }
        if (ClassUtils.hasMethod(metadata.getRepositoryInterface(), (String)FIND_ALL, (Class[])new Class[0])) {
            return DefaultCrudMethods.getMostSpecificMethod(ReflectionUtils.findMethod(CrudRepository.class, (String)FIND_ALL), metadata.getRepositoryInterface());
        }
        return Optional.empty();
    }

    private Optional<Method> selectMostSuitableFindOneMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(metadata.getIdType(), Serializable.class)) {
            Method candidate = ReflectionUtils.findMethod(metadata.getRepositoryInterface(), (String)FIND_ONE, (Class[])new Class[]{type});
            if (candidate == null) continue;
            return DefaultCrudMethods.getMostSpecificMethod(candidate, metadata.getRepositoryInterface());
        }
        return Optional.empty();
    }

    private static Optional<Method> getMostSpecificMethod(Method method, Class<?> type) {
        return Optional.ofNullable(ClassUtils.getMostSpecificMethod((Method)method, type)).map(it -> {
            ReflectionUtils.makeAccessible((Method)it);
            return it;
        });
    }

    @Override
    public Optional<Method> getSaveMethod() {
        return this.saveMethod;
    }

    @Override
    public boolean hasSaveMethod() {
        return this.saveMethod.isPresent();
    }

    @Override
    public Optional<Method> getFindAllMethod() {
        return this.findAllMethod;
    }

    @Override
    public boolean hasFindAllMethod() {
        return this.findAllMethod.isPresent();
    }

    @Override
    public Optional<Method> getFindOneMethod() {
        return this.findOneMethod;
    }

    @Override
    public boolean hasFindOneMethod() {
        return this.findOneMethod.isPresent();
    }

    @Override
    public boolean hasDelete() {
        return this.deleteMethod.isPresent();
    }

    @Override
    public Optional<Method> getDeleteMethod() {
        return this.deleteMethod;
    }
}

