/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.EventPublishingRepositoryProxyPostProcessor;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.DefaultEvaluationContextProvider;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;

public abstract class RepositoryFactoryBeanSupport<T extends Repository<S, ID>, S, ID extends Serializable>
implements InitializingBean,
RepositoryFactoryInformation<S, ID>,
FactoryBean<T>,
BeanClassLoaderAware,
BeanFactoryAware,
ApplicationEventPublisherAware {
    private final Class<? extends T> repositoryInterface;
    private RepositoryFactorySupport factory;
    private QueryLookupStrategy.Key queryLookupStrategyKey;
    private Optional<Class<?>> repositoryBaseClass = Optional.empty();
    private Optional<Object> customImplementation = Optional.empty();
    private NamedQueries namedQueries;
    private Optional<MappingContext<?, ?>> mappingContext;
    private ClassLoader classLoader;
    private BeanFactory beanFactory;
    private boolean lazyInit = false;
    private EvaluationContextProvider evaluationContextProvider = DefaultEvaluationContextProvider.INSTANCE;
    private ApplicationEventPublisher publisher;
    private Lazy<T> repository;
    private RepositoryMetadata repositoryMetadata;

    protected RepositoryFactoryBeanSupport(Class<? extends T> repositoryInterface) {
        Assert.notNull(repositoryInterface, (String)"Repository interface must not be null!");
        this.repositoryInterface = repositoryInterface;
    }

    public void setRepositoryBaseClass(Class<?> repositoryBaseClass) {
        this.repositoryBaseClass = Optional.ofNullable(repositoryBaseClass);
    }

    public void setQueryLookupStrategyKey(QueryLookupStrategy.Key queryLookupStrategyKey) {
        this.queryLookupStrategyKey = queryLookupStrategyKey;
    }

    public void setCustomImplementation(Object customImplementation) {
        this.customImplementation = Optional.ofNullable(customImplementation);
    }

    public void setNamedQueries(NamedQueries namedQueries) {
        this.namedQueries = namedQueries;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        this.mappingContext = Optional.ofNullable(mappingContext);
    }

    public void setEvaluationContextProvider(EvaluationContextProvider evaluationContextProvider) {
        this.evaluationContextProvider = evaluationContextProvider == null ? DefaultEvaluationContextProvider.INSTANCE : evaluationContextProvider;
    }

    public void setLazyInit(boolean lazy) {
        this.lazyInit = lazy;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public EntityInformation<S, ID> getEntityInformation() {
        return this.factory.getEntityInformation(this.repositoryMetadata.getDomainType());
    }

    @Override
    public RepositoryInformation getRepositoryInformation() {
        return this.factory.getRepositoryInformation(this.repositoryMetadata, this.customImplementation.map(Object::getClass));
    }

    @Override
    public PersistentEntity<?, ?> getPersistentEntity() {
        return this.mappingContext.orElseThrow(() -> new IllegalStateException("No MappingContext available!")).getRequiredPersistentEntity(this.repositoryMetadata.getDomainType());
    }

    @Override
    public List<QueryMethod> getQueryMethods() {
        return this.factory.getQueryMethods();
    }

    public T getObject() {
        return (T)((Repository)this.repository.get());
    }

    public Class<? extends T> getObjectType() {
        return this.repositoryInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        this.factory = this.createRepositoryFactory();
        this.factory.setQueryLookupStrategyKey(this.queryLookupStrategyKey);
        this.factory.setNamedQueries(this.namedQueries);
        this.factory.setEvaluationContextProvider(this.evaluationContextProvider);
        this.factory.setBeanClassLoader(this.classLoader);
        this.factory.setBeanFactory(this.beanFactory);
        if (this.publisher != null) {
            this.factory.addRepositoryProxyPostProcessor(new EventPublishingRepositoryProxyPostProcessor(this.publisher));
        }
        this.repositoryBaseClass.ifPresent(it -> this.factory.setRepositoryBaseClass((Class<?>)it));
        this.repositoryMetadata = this.factory.getRepositoryMetadata(this.repositoryInterface);
        this.repository = Lazy.of(() -> (Repository)this.factory.getRepository(this.repositoryInterface, this.customImplementation));
        if (!this.lazyInit) {
            this.repository.get();
        }
    }

    protected abstract RepositoryFactorySupport createRepositoryFactory();
}

