/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.beans.ConstructorProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.data.repository.query.spi.EvaluationContextExtension;
import org.springframework.data.repository.query.spi.Function;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class EvaluationContextExtensionInformation {
    private final ExtensionTypeInformation extensionTypeInformation;
    private final Optional<RootObjectInformation> rootObjectInformation;

    public EvaluationContextExtensionInformation(Class<? extends EvaluationContextExtension> type) {
        Assert.notNull(type, (String)"Extension type must not be null!");
        Class<?> rootObjectType = EvaluationContextExtensionInformation.getRootObjectMethod(type).getReturnType();
        this.rootObjectInformation = Optional.ofNullable(Object.class.equals(rootObjectType) ? null : new RootObjectInformation(rootObjectType));
        this.extensionTypeInformation = new ExtensionTypeInformation(type);
    }

    public ExtensionTypeInformation getExtensionTypeInformation() {
        return this.extensionTypeInformation;
    }

    public RootObjectInformation getRootObjectInformation(Optional<Object> target) {
        return target.map(it -> this.rootObjectInformation.orElseGet(() -> new RootObjectInformation(it.getClass()))).orElse(RootObjectInformation.NONE);
    }

    private static Method getRootObjectMethod(Class<?> type) {
        try {
            return type.getMethod("getRootObject", new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Map<String, Object> discoverDeclaredProperties(Class<?> type) {
        HashMap map = new HashMap();
        ReflectionUtils.doWithFields(type, field -> map.put(field.getName(), field.get(null)), (ReflectionUtils.FieldFilter)ExtensionTypeInformation.PublicMethodAndFieldFilter.STATIC);
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    static class RootObjectInformation {
        private static final RootObjectInformation NONE = new RootObjectInformation(Object.class);
        private final Map<String, Method> accessors;
        private final Collection<Method> methods;
        private final Collection<Field> fields;

        public RootObjectInformation(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            this.accessors = new HashMap<String, Method>();
            this.methods = new HashSet<Method>();
            this.fields = new ArrayList<Field>();
            if (Object.class.equals(type)) {
                return;
            }
            Streamable<PropertyDescriptor> descriptors = Streamable.of(BeanUtils.getPropertyDescriptors(type));
            ReflectionUtils.doWithMethods(type, method -> {
                this.methods.add(method);
                descriptors.stream().filter(it -> method.equals(it.getReadMethod())).forEach(it -> this.accessors.put(it.getName(), method));
            }, (ReflectionUtils.MethodFilter)ExtensionTypeInformation.PublicMethodAndFieldFilter.NON_STATIC);
            ReflectionUtils.doWithFields(type, this.fields::add, (ReflectionUtils.FieldFilter)ExtensionTypeInformation.PublicMethodAndFieldFilter.NON_STATIC);
        }

        public Map<String, Function> getFunctions(Optional<Object> target) {
            return target.map(it -> this.methods.stream().collect(Collectors.toMap(Method::getName, method -> new Function((Method)method, it), (left, right) -> right))).orElseGet(Collections::emptyMap);
        }

        public Map<String, Object> getProperties(Optional<Object> target) {
            return target.map(it -> {
                HashMap properties = new HashMap();
                this.accessors.entrySet().stream().forEach(method -> properties.put(method.getKey(), new Function((Method)method.getValue(), it)));
                this.fields.stream().forEach(field -> properties.put(field.getName(), ReflectionUtils.getField((Field)field, (Object)it)));
                return Collections.unmodifiableMap(properties);
            }).orElseGet(Collections::emptyMap);
        }
    }

    public static class ExtensionTypeInformation {
        private final Map<String, Object> properties;
        private final Map<String, Function> functions;

        public ExtensionTypeInformation(Class<? extends EvaluationContextExtension> type) {
            Assert.notNull(type, (String)"Extension type must not be null!");
            this.functions = ExtensionTypeInformation.discoverDeclaredFunctions(type);
            this.properties = EvaluationContextExtensionInformation.discoverDeclaredProperties(type);
        }

        private static Map<String, Function> discoverDeclaredFunctions(Class<?> type) {
            HashMap map = new HashMap();
            ReflectionUtils.doWithMethods(type, method -> map.put(method.getName(), new Function(method, null)), (ReflectionUtils.MethodFilter)PublicMethodAndFieldFilter.STATIC);
            return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public Map<String, Function> getFunctions() {
            return this.functions;
        }

        static class PublicMethodAndFieldFilter
        implements ReflectionUtils.MethodFilter,
        ReflectionUtils.FieldFilter {
            public static final PublicMethodAndFieldFilter STATIC = new PublicMethodAndFieldFilter(true);
            public static final PublicMethodAndFieldFilter NON_STATIC = new PublicMethodAndFieldFilter(false);
            private final boolean staticOnly;

            public boolean matches(Method method) {
                if (ReflectionUtils.isObjectMethod((Method)method)) {
                    return false;
                }
                boolean methodStatic = Modifier.isStatic(method.getModifiers());
                boolean staticMatch = this.staticOnly ? methodStatic : !methodStatic;
                return Modifier.isPublic(method.getModifiers()) && staticMatch;
            }

            public boolean matches(Field field) {
                boolean fieldStatic = Modifier.isStatic(field.getModifiers());
                boolean staticMatch = this.staticOnly ? fieldStatic : !fieldStatic;
                return Modifier.isPublic(field.getModifiers()) && staticMatch;
            }

            @ConstructorProperties(value={"staticOnly"})
            public PublicMethodAndFieldFilter(boolean staticOnly) {
                this.staticOnly = staticOnly;
            }
        }
    }
}

