/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.springframework.data.util.ClassTypeInformation;

public interface TypeInformation<S> {
    public List<TypeInformation<?>> getParameterTypes(Constructor<?> var1);

    public Optional<TypeInformation<?>> getProperty(String var1);

    default public TypeInformation<?> getRequiredProperty(String property) {
        return this.getProperty(property).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find required property %s on %s!", property, this.getType())));
    }

    public boolean isCollectionLike();

    public Optional<TypeInformation<?>> getComponentType();

    default public TypeInformation<?> getRequiredComponentType() {
        return this.getComponentType().orElseThrow(() -> new IllegalStateException(String.format("Can't resolve required component type for %s!", this.getType())));
    }

    public boolean isMap();

    public Optional<TypeInformation<?>> getMapValueType();

    default public TypeInformation<?> getRequiredMapValueType() {
        return this.getMapValueType().orElseThrow(() -> new IllegalStateException(String.format("Can't resolve required map value type for %s!", this.getType())));
    }

    public Class<S> getType();

    public ClassTypeInformation<?> getRawTypeInformation();

    public TypeInformation<?> getActualType();

    public TypeInformation<?> getReturnType(Method var1);

    public List<TypeInformation<?>> getParameterTypes(Method var1);

    public TypeInformation<?> getSuperTypeInformation(Class<?> var1);

    public boolean isAssignableFrom(TypeInformation<?> var1);

    public List<TypeInformation<?>> getTypeArguments();

    public TypeInformation<? extends S> specialize(ClassTypeInformation<?> var1);
}

