/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedTypeReference;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.repository.aot.generate.AotRepositoryBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryClassBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.JSONException;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.aot.generate.RepositoryConstructorBuilder;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeSpec;

public class RepositoryContributor {
    private static final Log logger = LogFactory.getLog(RepositoryContributor.class);
    private static final String FEATURE_NAME = "AotRepository";
    private final AotRepositoryBuilder builder;
    private @Nullable TypeReference contributedTypeName;

    public RepositoryContributor(AotRepositoryContext repositoryContext) {
        this.builder = AotRepositoryBuilder.forRepository(repositoryContext.getRepositoryInformation(), repositoryContext.getModuleName(), this.createProjectionFactory());
    }

    protected ProjectionFactory createProjectionFactory() {
        return new SpelAwareProxyProjectionFactory();
    }

    protected ProjectionFactory getProjectionFactory() {
        return this.builder.getProjectionFactory();
    }

    protected RepositoryInformation getRepositoryInformation() {
        return this.builder.getRepositoryInformation();
    }

    public @Nullable TypeReference getContributedTypeName() {
        return this.contributedTypeName;
    }

    public Map<String, TypeName> requiredArgs() {
        return this.builder.getAutowireFields();
    }

    public void contribute(GenerationContext generationContext) {
        this.builder.withClassCustomizer(this::customizeClass).withConstructorCustomizer(this::customizeConstructor).withQueryMethodContributor(this::contributeQueryMethod);
        RepositoryConstructorBuilder constructorBuilder = new RepositoryConstructorBuilder(this.builder.getGenerationMetadata());
        this.customizeConstructor(constructorBuilder);
        GeneratedClass generatedClass = generationContext.getGeneratedClasses().getOrAddForFeatureComponent(FEATURE_NAME, this.builder.getClassName(), targetTypeSpec -> {
            String repositoryJson;
            this.builder.withClassName(targetTypeSpec.build().name());
            AotRepositoryBuilder.AotBundle aotBundle = this.builder.build((TypeSpec.Builder)targetTypeSpec);
            Class<?> repositoryInterface = this.getRepositoryInformation().getRepositoryInterface();
            String repositoryJsonFileName = RepositoryContributor.getRepositoryJsonFileName(repositoryInterface);
            try {
                repositoryJson = aotBundle.metadata().toJson().toString(2);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"------ AOT Repository.json: %s ------\n%s\n-------------------\n".formatted(repositoryJsonFileName, repositoryJson));
                logger.trace((Object)"------ AOT Generated Repository: %s ------\n%s\n-------------------\n".formatted(null, aotBundle.javaFile()));
            }
            generationContext.getGeneratedFiles().addResourceFile(repositoryJsonFileName, (CharSequence)repositoryJson);
        });
        this.contributedTypeName = GeneratedTypeReference.of((ClassName)generatedClass.getName());
        generationContext.getRuntimeHints().reflection().registerType(this.contributedTypeName, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
    }

    private static String getRepositoryJsonFileName(Class<?> repositoryInterface) {
        return repositoryInterface.getName().replace('.', '/') + ".json";
    }

    protected void customizeClass(AotRepositoryClassBuilder builder) {
    }

    protected void customizeConstructor(AotRepositoryConstructorBuilder builder) {
    }

    protected @Nullable MethodContributor<? extends QueryMethod> contributeQueryMethod(Method method) {
        return null;
    }
}

