/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.util.Assert;

@FunctionalInterface
interface ReactiveCouchbaseQueryExecution {
    public Object execute(Query var1, Class<?> var2, Class<?> var3, String var4);

    public static final class ResultProcessingExecution
    implements ReactiveCouchbaseQueryExecution {
        private final ReactiveCouchbaseQueryExecution delegate;
        private final Converter<Object, Object> converter;

        public ResultProcessingExecution(ReactiveCouchbaseQueryExecution delegate, Converter<Object, Object> converter) {
            Assert.notNull((Object)delegate, (String)"Delegate must not be null!");
            Assert.notNull(converter, (String)"Converter must not be null!");
            this.delegate = delegate;
            this.converter = converter;
        }

        @Override
        public Object execute(Query query, Class<?> type, Class<?> returnType, String collection) {
            return this.converter.convert(this.delegate.execute(query, type, returnType, collection));
        }
    }

    public static final class DeleteExecution
    implements ReactiveCouchbaseQueryExecution {
        private final ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery removeOp;

        public DeleteExecution(ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<?> removeOp) {
            this.removeOp = removeOp;
        }

        @Override
        public Object execute(Query query, Class<?> type, Class<?> returnType, String collection) {
            return this.removeOp.matching(query).all();
        }
    }
}

